/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config;

import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.exception.BeanDefinitionStoreException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.Constant;
import cn.taketoday.web.DefaultWebApplicationContext;
import cn.taketoday.web.ServletContextInitializer;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.config.ViewConfiguration;
import cn.taketoday.web.config.initializer.DispatcherServletInitializer;
import cn.taketoday.web.event.ApplicationStartedEvent;
import cn.taketoday.web.multipart.AbstractMultipartResolver;
import cn.taketoday.web.multipart.DefaultMultipartResolver;
import cn.taketoday.web.resolver.DefaultExceptionResolver;
import cn.taketoday.web.resolver.DefaultParameterResolver;
import cn.taketoday.web.view.AbstractViewResolver;
import cn.taketoday.web.view.FreeMarkerViewResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@HandlesTypes(value={Object.class})
public class WebServletContainerInitializer
implements ServletContainerInitializer,
Constant {
    private static final Logger log = LoggerFactory.getLogger(WebServletContainerInitializer.class);
    private ViewConfiguration viewConfiguration;
    private static WebApplicationContext applicationContext;
    private DocumentBuilder builder;

    public static WebApplicationContext getWebApplicationContext() {
        return applicationContext;
    }

    private void initFrameWorkFromWebMvcXml(ServletContext servletContext) throws Throwable {
        log.info("TODAY WEB Framework Is Looking For Configuration File.");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        this.builder = factory.newDocumentBuilder();
        this.builder.setEntityResolver((publicId, systemId) -> {
            if (systemId.contains("web-configuration") || publicId.contains("web-configuration")) {
                return new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes()));
            }
            return null;
        });
        String webMvcConfigLocation = WebServletContainerInitializer.getWebApplicationContext().getEnvironment().getProperty("WebMvcConfigLocation");
        if (StringUtils.isEmpty((String)webMvcConfigLocation) && StringUtils.isEmpty((String)(webMvcConfigLocation = servletContext.getInitParameter("WebMvcConfigLocation")))) {
            String rootPath = servletContext.getRealPath("/");
            log.debug("Find Configuration File From Root Path: [{}]", (Object)rootPath);
            this.findConfiguration(new File(rootPath));
            return;
        }
        for (String file : StringUtils.split((String)webMvcConfigLocation)) {
            URL resource = ClassUtils.getClassLoader().getResource(file);
            if (resource == null) {
                ConfigurationException configurationException = new ConfigurationException("Your Provided Configuration File: [" + webMvcConfigLocation + "], Does Not Exist");
                servletContext.log(configurationException.getMessage(), (Throwable)configurationException);
                throw configurationException;
            }
            try (FileInputStream inputStream = new FileInputStream(resource.getFile());){
                this.registerXml(this.builder.parse(inputStream), webMvcConfigLocation);
            }
        }
        this.builder = null;
    }

    private void findConfiguration(File dir) throws Throwable {
        log.debug("Enter [{}]", (Object)dir.getAbsolutePath());
        File[] listFiles = dir.listFiles(path -> path.isDirectory() || path.getName().endsWith(".xml"));
        if (listFiles == null) {
            log.error("File: [{}] Does not exist", (Object)dir);
            return;
        }
        for (File file : listFiles) {
            if (file.isDirectory()) {
                this.findConfiguration(file);
                continue;
            }
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.registerXml(this.builder.parse(inputStream), file.getAbsolutePath());
            }
        }
    }

    private final void registerXml(Document doc, String filePath) throws Throwable {
        Element root = doc.getDocumentElement();
        if ("Web-Configuration".equals(root.getNodeName())) {
            log.info("Found Configuration File: [{}].", (Object)filePath);
            this.configStart(root);
        }
    }

    private void configStart(Element root) throws Throwable {
        NodeList nl = root.getChildNodes();
        block18: for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String nodeName = ele.getNodeName();
            log.debug("Found Element: [{}]", (Object)nodeName);
            switch (nodeName) {
                case "controller": {
                    this.viewConfiguration.configuration(ele);
                    continue block18;
                }
                case "static-resources": {
                    String mapping = ele.getAttribute("mapping");
                    if (!StringUtils.isNotEmpty((String)mapping)) continue block18;
                    WebServletContainerInitializer.addDefaultServletMapping(mapping);
                    continue block18;
                }
                case "multipart": {
                    this.multipartResolver(ele);
                    continue block18;
                }
                case "view-resolver": {
                    this.viewResolver(ele);
                    continue block18;
                }
                case "exception-resolver": {
                    WebServletContainerInitializer.registerResolver(ele, DefaultExceptionResolver.class, "exceptionResolver", true);
                    continue block18;
                }
                case "parameter-resolver": {
                    WebServletContainerInitializer.registerResolver(ele, DefaultParameterResolver.class, "parameterResolver", true);
                    continue block18;
                }
                case "dispatcher-servlet": {
                    String mapping = ele.getAttribute("mapping");
                    if (StringUtils.isEmpty((String)mapping)) {
                        log.warn("Attribute: [{}] on [{}] is Empty", (Object)"mapping", (Object)nodeName);
                        continue block18;
                    }
                    DispatcherServletInitializer bean = (DispatcherServletInitializer)applicationContext.getBean(DispatcherServletInitializer.class);
                    log.info("Set DispatcherServlet Url Mappings: [{}]", (Object)mapping);
                    bean.setDispatcherServletMapping(mapping);
                    continue block18;
                }
                default: {
                    log.warn("This element: [{}] is not supported.", (Object)nodeName);
                }
            }
        }
    }

    static Class<?> registerResolver(Element element, Class<?> defaultClass, String name, boolean refresh) throws ClassNotFoundException, BeanDefinitionStoreException {
        String attrClass = element.getAttribute("class");
        Class<?> resolverClass = null;
        resolverClass = !defaultClass.getName().equals(attrClass) ? Class.forName(attrClass) : defaultClass;
        applicationContext.registerBean(name, resolverClass);
        log.info("Register [{}] onto [{}]", (Object)name, (Object)resolverClass.getName());
        if (refresh) {
            applicationContext.refresh(name);
        }
        return resolverClass;
    }

    private void viewResolver(Element element) throws Throwable {
        WebApplicationContext applicationContext = WebServletContainerInitializer.getWebApplicationContext();
        Class<?> viewResolverClass = WebServletContainerInitializer.registerResolver(element, FreeMarkerViewResolver.class, "viewResolver", false);
        Object viewResolver = ClassUtils.newInstance(viewResolverClass);
        if (viewResolver instanceof AbstractViewResolver) {
            this.doAbstractViewResolver(element, (AbstractViewResolver)viewResolver);
        }
        applicationContext.registerSingleton("viewResolver", viewResolver);
        applicationContext.refresh("viewResolver");
    }

    private void doAbstractViewResolver(Element element, AbstractViewResolver abstractViewResolver) {
        Properties properties = applicationContext.getEnvironment().getProperties();
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        block12: for (int j = 0; j < length; ++j) {
            Node item = childNodes.item(j);
            if (!(item instanceof Element)) continue;
            Element config = (Element)item;
            String eleName = config.getNodeName();
            String nodeValue = ContextUtils.resolvePlaceholder((Map)properties, (String)config.getTextContent());
            log.debug("Found Element: [{}] = [{}]", (Object)eleName, (Object)nodeValue);
            switch (eleName) {
                case "view-encoding": {
                    abstractViewResolver.setEncoding(nodeValue);
                    continue block12;
                }
                case "view-prefix": {
                    abstractViewResolver.setPrefix(nodeValue);
                    continue block12;
                }
                case "view-suffix": {
                    abstractViewResolver.setSuffix(nodeValue);
                    continue block12;
                }
                case "view-locale": {
                    abstractViewResolver.setLocale(new Locale(nodeValue));
                    continue block12;
                }
                default: {
                    log.error("This element -> [{}] is not supported.", (Object)eleName);
                }
            }
        }
    }

    private void multipartResolver(Element element) throws Throwable {
        WebApplicationContext applicationContext = WebServletContainerInitializer.getWebApplicationContext();
        Class<?> multipartResolverClass = WebServletContainerInitializer.registerResolver(element, DefaultMultipartResolver.class, "multipartResolver", false);
        Object multipartResolver = ClassUtils.newInstance(multipartResolverClass);
        if (multipartResolver instanceof AbstractMultipartResolver) {
            this.doAbstractMultipartResolver(element, (AbstractMultipartResolver)multipartResolver);
        }
        applicationContext.registerSingleton("multipartResolver", multipartResolver);
        applicationContext.refresh("multipartResolver");
    }

    private void doAbstractMultipartResolver(Element element, AbstractMultipartResolver abstractMultipartResolver) {
        Properties properties = WebServletContainerInitializer.getWebApplicationContext().getEnvironment().getProperties();
        NodeList childNodes = element.getChildNodes();
        block14: for (int j = 0; j < childNodes.getLength(); ++j) {
            Node item = childNodes.item(j);
            if (!(item instanceof Element)) continue;
            Element multipart = (Element)item;
            String elementName = multipart.getNodeName();
            String nodeValue = ContextUtils.resolvePlaceholder((Map)properties, (String)multipart.getTextContent());
            log.debug("Found Element: [{}] = [{}]", (Object)elementName, (Object)nodeValue);
            switch (elementName) {
                case "upload-location": {
                    abstractMultipartResolver.setLocation(nodeValue);
                    continue block14;
                }
                case "upload-encoding": {
                    abstractMultipartResolver.setEncoding(nodeValue);
                    continue block14;
                }
                case "upload-maxFileSize": {
                    abstractMultipartResolver.setMaxFileSize(Long.parseLong(nodeValue));
                    continue block14;
                }
                case "upload-maxRequestSize": {
                    abstractMultipartResolver.setMaxRequestSize(Long.parseLong(nodeValue));
                    continue block14;
                }
                case "upload-fileSizeThreshold": {
                    abstractMultipartResolver.setFileSizeThreshold(Integer.parseInt(nodeValue));
                    continue block14;
                }
                default: {
                    log.error("This element -> [{}] is not supported.", (Object)elementName);
                }
            }
        }
    }

    static void addDefaultServletMapping(String staticMapping) throws Throwable {
        ServletContext servletContext = WebServletContainerInitializer.getWebApplicationContext().getServletContext();
        ServletRegistration servletRegistration = servletContext.getServletRegistration("default");
        if (servletRegistration == null) {
            throw new ConfigurationException("There isn't a default servlet, please check your configuration");
        }
        if (StringUtils.isEmpty((String)staticMapping)) {
            throw new ConfigurationException("Static sources mapping can't be empty, please check your configuration");
        }
        servletRegistration.addMapping(StringUtils.split((String)staticMapping));
        log.debug("Add default servlet mapping: [{}].", (Object)servletRegistration.getMappings());
    }

    static void checkFrameWorkResolvers() throws BeanDefinitionStoreException {
        WebApplicationContext applicationContext = WebServletContainerInitializer.getWebApplicationContext();
        if (!applicationContext.containsBeanDefinition("exceptionResolver")) {
            applicationContext.registerBean("exceptionResolver", DefaultExceptionResolver.class);
            applicationContext.refresh("exceptionResolver");
            log.info("Use default exception resolver: [{}].", DefaultExceptionResolver.class);
        }
        if (!applicationContext.containsBeanDefinition("multipartResolver")) {
            applicationContext.registerBean("multipartResolver", DefaultMultipartResolver.class);
            applicationContext.refresh("multipartResolver");
            log.info("Use default multipart resolver: [{}].", DefaultMultipartResolver.class);
        }
        if (!applicationContext.containsBeanDefinition("viewResolver")) {
            applicationContext.registerBean("viewResolver", FreeMarkerViewResolver.class);
            applicationContext.refresh("viewResolver");
            log.info("Use default view resolver: [{}].", FreeMarkerViewResolver.class);
        }
        if (!applicationContext.containsBeanDefinition("parameterResolver")) {
            applicationContext.registerBean("parameterResolver", DefaultParameterResolver.class);
            applicationContext.refresh("parameterResolver");
            log.info("Use default parameter resolver: [{}].", DefaultParameterResolver.class);
        }
    }

    private long prepareApplicationContext(Set<Class<?>> classes, ServletContext servletContext) {
        Object attribute = servletContext.getAttribute("WebApplicationContext");
        if (attribute != null && attribute instanceof WebApplicationContext) {
            applicationContext = (WebApplicationContext)attribute;
            return applicationContext.getStartupDate();
        }
        ClassUtils.setClassCache(classes);
        long start = System.currentTimeMillis();
        log.info("Your Application Starts To Be Initialized At: [{}].", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(start)));
        log.debug("There are [{}] classes in class path", (Object)classes.size());
        applicationContext = new DefaultWebApplicationContext(classes, servletContext);
        return start;
    }

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        Objects.requireNonNull(servletContext, "ServletContext can't be null");
        long start = this.prepareApplicationContext(classes, servletContext);
        try {
            WebApplicationContext applicationContext = WebServletContainerInitializer.getWebApplicationContext();
            ConfigurableEnvironment environment = applicationContext.getEnvironment();
            try {
                servletContext.setRequestCharacterEncoding("UTF-8");
                servletContext.setResponseCharacterEncoding("UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (Boolean.parseBoolean(environment.getProperty("enable.webmvc.xml", "true"))) {
                this.viewConfiguration = (ViewConfiguration)applicationContext.getBean("viewConfig", ViewConfiguration.class);
                this.initFrameWorkFromWebMvcXml(servletContext);
            }
            WebServletContainerInitializer.checkFrameWorkResolvers();
            List contextInitializers = applicationContext.getBeans(ServletContextInitializer.class);
            OrderUtils.reversedSort((List)contextInitializers);
            for (ServletContextInitializer servletContextInitializer : contextInitializers) {
                servletContextInitializer.onStartup(servletContext);
            }
            WebServletContainerInitializer.removeFrameWorkBeanDefinitions();
            applicationContext.publishEvent((EventObject)((Object)new ApplicationStartedEvent(applicationContext)));
            if (Boolean.parseBoolean(environment.getProperty("enable.started.log", "true"))) {
                log.info("Your Application Started Successfully, It takes a total of [{}] ms.", (Object)(System.currentTimeMillis() - start));
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> applicationContext.close()));
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable((Throwable)ex);
            log.error("Your Application Initialized ERROR: [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new ConfigurationException(ex);
        }
    }

    static void removeFrameWorkBeanDefinitions() {
        applicationContext.destroyBean("viewConfig");
        applicationContext.destroyBean("actionConfig");
    }
}

