/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.bean.DefaultBeanDefinition;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.WebApplicationContextAware;
import cn.taketoday.web.mapping.ViewMapping;
import cn.taketoday.web.servlet.ViewDispatcher;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton(value={"viewConfig"})
public class ViewConfiguration
implements WebApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(ViewConfiguration.class);
    private String contextPath;
    private Properties variables;
    private BeanNameCreator beanNameCreator;
    private WebApplicationContext applicationContext;

    public void configuration(Element controller) throws Exception {
        Objects.requireNonNull(controller, "'controller' element can't be null");
        String name = controller.getAttribute("name");
        String prefix = controller.getAttribute("prefix");
        String suffix = controller.getAttribute("suffix");
        String className = controller.getAttribute("class");
        Class beanClass = null;
        Object controllerBean = null;
        if (StringUtils.isNotEmpty((String)className)) {
            beanClass = ClassUtils.forName((String)className);
            if (StringUtils.isEmpty((String)name)) {
                name = this.beanNameCreator.create(beanClass);
            }
            if (!this.applicationContext.containsBeanDefinition(beanClass)) {
                this.applicationContext.registerBean(name, (BeanDefinition)new DefaultBeanDefinition(name, beanClass));
                this.applicationContext.refresh(name);
            }
            controllerBean = this.applicationContext.getBean(beanClass);
        }
        NodeList nl = controller.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getNodeName();
            if (nodeName.equals("action")) {
                this.processAction(prefix, suffix, (Element)node, beanClass).setController(controllerBean);
                continue;
            }
            this.log.warn("This element: [{}] is not supported.", (Object)nodeName);
        }
    }

    private ViewMapping processAction(String prefix, String suffix, Element action, Class<?> class_) throws Exception {
        ViewMapping mapping = new ViewMapping();
        String name = action.getAttribute("name");
        String type = action.getAttribute("type");
        String method = action.getAttribute("method");
        String resource = action.getAttribute("resource");
        String contentType = action.getAttribute("content-type");
        if (StringUtils.isEmpty((String)name)) {
            throw new ConfigurationException("You must specify a 'name' attribute like this: [<action resource=\"https://taketoday.cn\" name=\"TODAY-BLOG\" type=\"redirect\"/>]");
        }
        if (StringUtils.isNotEmpty((String)method)) {
            Method handelrMethod = class_.getDeclaredMethod(method, HttpServletRequest.class, HttpServletResponse.class);
            mapping.setAction(handelrMethod);
            Class<?> returnType = handelrMethod.getReturnType();
            if (returnType == String.class) {
                mapping.setReturnType((byte)5);
            } else if (Image.class.isAssignableFrom(returnType) || RenderedImage.class.isAssignableFrom(returnType)) {
                mapping.setReturnType((byte)4);
            } else if (returnType == Void.TYPE) {
                mapping.setReturnType((byte)0);
            } else {
                mapping.setReturnType((byte)7);
            }
        }
        resource = ContextUtils.resolvePlaceholder((Map)this.variables, (String)(prefix + resource + suffix), (boolean)false);
        if ("redirect".equals(type)) {
            mapping.setReturnType((byte)2);
            if (!resource.startsWith("http")) {
                resource = this.contextPath + resource;
            }
        } else if ("forward".equals(type)) {
            mapping.setReturnType((byte)1);
        }
        mapping.setAssetsPath(resource);
        if (StringUtils.isNotEmpty((String)contentType)) {
            mapping.setContentType(contentType);
        }
        name = ContextUtils.resolvePlaceholder((Map)this.variables, (String)(this.contextPath + (name.startsWith("/") ? name : "/" + name)));
        ViewDispatcher.register(name, mapping);
        this.log.info("View Mapped [{} -> {}]", (Object)name, (Object)mapping);
        return mapping;
    }

    @Override
    public void setWebApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.variables = applicationContext.getEnvironment().getProperties();
        this.beanNameCreator = applicationContext.getEnvironment().getBeanNameCreator();
        this.contextPath = applicationContext.getServletContext().getContextPath();
    }
}

