/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config;

import cn.taketoday.context.AnnotationAttributes;
import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.DisposableBean;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.NumberUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.RequestMethod;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.WebApplicationContextAware;
import cn.taketoday.web.annotation.ActionMapping;
import cn.taketoday.web.annotation.Controller;
import cn.taketoday.web.annotation.Interceptor;
import cn.taketoday.web.annotation.PathVariable;
import cn.taketoday.web.annotation.RequestParam;
import cn.taketoday.web.annotation.ResponseBody;
import cn.taketoday.web.config.initializer.OrderedInitializer;
import cn.taketoday.web.interceptor.HandlerInterceptor;
import cn.taketoday.web.mapping.HandlerInterceptorRegistry;
import cn.taketoday.web.mapping.HandlerMapping;
import cn.taketoday.web.mapping.HandlerMappingRegistry;
import cn.taketoday.web.mapping.HandlerMethod;
import cn.taketoday.web.mapping.MethodParameter;
import cn.taketoday.web.multipart.MultipartFile;
import cn.taketoday.web.ui.Model;
import cn.taketoday.web.ui.ModelAndView;
import cn.taketoday.web.ui.ModelAttributes;
import cn.taketoday.web.ui.RedirectModel;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton(value={"actionConfig"})
public class ActionConfiguration
implements OrderedInitializer,
WebApplicationContextAware,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(ActionConfiguration.class);
    private String contextPath;
    private Map<String, Integer> regexUrls = new HashMap<String, Integer>();
    private Map<String, Integer> requestMappings = new HashMap<String, Integer>();
    @Autowired(value="handlerMappingRegistry")
    public HandlerMappingRegistry handlerMappingRegistry;
    @Autowired(value="handlerInterceptorRegistry")
    public HandlerInterceptorRegistry handlerInterceptorRegistry;
    private WebApplicationContext applicationContext;
    private BeanDefinitionLoader beanDefinitionLoader;
    private Properties variables;

    public void configuration() throws Exception {
        this.log.info("Initializing Actions And Find ParameterResolver");
        this.startConfiguration();
        this.handlerMappingRegistry.setRegexMappings(new HashMap<String, Integer>(this.regexUrls)).setRequestMappings(new HashMap<String, Integer>(this.requestMappings));
    }

    public void startConfiguration() throws Exception {
        for (Map.Entry entry : this.applicationContext.getBeanDefinitionsMap().entrySet()) {
            Class beanClass = ((BeanDefinition)entry.getValue()).getBeanClass();
            Collection annotationAttributes = ClassUtils.getAnnotationAttributes((AnnotatedElement)beanClass, Controller.class);
            if (annotationAttributes.isEmpty()) continue;
            Collection controllerMappings = ClassUtils.getAnnotation((AnnotatedElement)beanClass, ActionMapping.class);
            HashSet<String> namespaces = new HashSet<String>(4, 1.0f);
            HashSet<RequestMethod> methodsOnClass = new HashSet<RequestMethod>(8, 1.0f);
            if (!controllerMappings.isEmpty()) {
                ActionMapping controllerMapping = (ActionMapping)controllerMappings.iterator().next();
                for (String value : controllerMapping.value()) {
                    namespaces.add(ActionConfiguration.checkUrl(value));
                }
                Collections.addAll(methodsOnClass, controllerMapping.method());
            }
            AnnotationAttributes attributes = (AnnotationAttributes)annotationAttributes.iterator().next();
            boolean restful = attributes.getBoolean("restful");
            for (Method method : beanClass.getDeclaredMethods()) {
                this.setActionMapping(beanClass, method, namespaces, methodsOnClass, restful);
            }
        }
    }

    private void setActionMapping(Class<?> beanClass, Method method, Set<String> namespaces, Set<RequestMethod> methodsOnClass, boolean restful) throws Exception {
        Collection annotationAttributes = ClassUtils.getAnnotationAttributes((AnnotatedElement)method, ActionMapping.class);
        if (annotationAttributes.isEmpty()) {
            return;
        }
        this.mappingHandlerMapping(this.createHandlerMapping(beanClass, method, restful), namespaces, methodsOnClass, annotationAttributes);
    }

    @SafeVarargs
    static <E> Set<E> newHashSet(final E ... elements) {
        return new HashSet<E>(8, 1.0f){
            {
                super(x0, x1);
                for (Object element : elements) {
                    this.add(element);
                }
            }
        };
    }

    private void mappingHandlerMapping(HandlerMapping handlerMapping, Set<String> namespaces, Set<RequestMethod> classRequestMethods, Collection<AnnotationAttributes> annotationAttributes) {
        HandlerMethod handlerMethod = handlerMapping.getHandlerMethod();
        for (AnnotationAttributes handlerMethodMapping : annotationAttributes) {
            boolean exclude = handlerMethodMapping.getBoolean("exclude");
            Set<Object> requestMethods = ActionConfiguration.newHashSet((Object[])handlerMethodMapping.getAttribute("method", RequestMethod[].class));
            requestMethods.addAll(classRequestMethods);
            for (String urlOnMethod : handlerMethodMapping.getStringArray("value")) {
                for (RequestMethod requestMethod : requestMethods) {
                    if (exclude || namespaces.isEmpty()) {
                        this.doMapping(handlerMapping, handlerMethod, ActionConfiguration.checkUrl(urlOnMethod), requestMethod);
                        continue;
                    }
                    for (String namespace : namespaces) {
                        this.doMapping(handlerMapping, handlerMethod, namespace + ActionConfiguration.checkUrl(urlOnMethod), requestMethod);
                    }
                }
            }
        }
    }

    private void doMapping(HandlerMapping handlerMapping, HandlerMethod handlerMethod, String urlOnMethod, RequestMethod requestMethod) {
        urlOnMethod = requestMethod.name() + this.contextPath + ContextUtils.resolvePlaceholder((Map)this.variables, (String)urlOnMethod);
        int index = this.handlerMappingRegistry.add(handlerMapping);
        if (!this.doMappingPathVariable(urlOnMethod, handlerMethod.getParameter(), handlerMethod.getMethod(), index, requestMethod.name())) {
            this.requestMappings.put(urlOnMethod, index);
            this.log.info("Mapped [{}] -> [{}] interceptors -> {}", new Object[]{urlOnMethod, handlerMethod.getMethod(), Arrays.toString((Object[])handlerMapping.getInterceptors())});
        }
    }

    private boolean doMappingPathVariable(String regexUrl, MethodParameter[] methodParameters, Method method, int index, String requestMethod_) {
        if (!regexUrl.contains("*") && !regexUrl.contains("{")) {
            return false;
        }
        String methodUrl = regexUrl;
        regexUrl = regexUrl.replaceAll("\\*\\*", "[\\\\s\\\\S|/]+");
        regexUrl = regexUrl.replaceAll("\\*", "[\\\\s\\\\S]+");
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            MethodParameter methodParameter = methodParameters[i];
            if (!methodParameter.hasPathVariable()) continue;
            Class<?> parameterClass = methodParameter.getParameterClass();
            PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
            if (pathVariable == null) {
                throw new ConfigurationException("You must specify a @PathVariable Like this: [public String update(@PathVariable int id, ..) {...}]");
            }
            String regex = pathVariable.regex();
            if (StringUtils.isEmpty((String)regex)) {
                regex = parameterClass == String.class ? "\\w+" : "\\d+";
            }
            String parameterName = methodParameter.getParameterName();
            regexUrl = regexUrl.replace("{" + parameterName + "}", regex);
            String[] splitRegex = methodUrl.split("\\{(\\w+)\\}");
            String tempMethodUrl = methodUrl;
            for (String reg : splitRegex) {
                tempMethodUrl = tempMethodUrl.replaceFirst(reg, "\\\\");
            }
            String[] regexArr = tempMethodUrl.split("\\\\");
            for (int j = 0; j < regexArr.length; ++j) {
                if (!regexArr[j].equals("{" + parameterName + "}")) continue;
                methodParameter.setPathIndex(j);
            }
            methodParameter.setSplitMethodUrl(methodUrl.replace(requestMethod_, "").split("\\{(\\w+)\\}"));
        }
        this.regexUrls.put(regexUrl, index);
        this.log.info("Mapped [{}] -> [{}]", (Object)regexUrl, (Object)method);
        return true;
    }

    static String checkUrl(String url) {
        return StringUtils.isEmpty((String)url) ? "" : (url.startsWith("/") ? url : "/" + url);
    }

    private HandlerMapping createHandlerMapping(Class<?> beanClass, Method method, boolean restful) throws Exception {
        HandlerMapping handlerMapping = new HandlerMapping();
        Parameter[] parameters = method.getParameters();
        ArrayList<MethodParameter> methodParameters = new ArrayList<MethodParameter>();
        this.setMethodParameter(parameters, methodParameters, method);
        HandlerMethod handlerMethod = new HandlerMethod(method, methodParameters);
        handlerMethod.setReutrnType(this.returnType(method, method.getReturnType(), restful));
        handlerMapping.setHandlerMethod(handlerMethod);
        Object bean = this.applicationContext.getBean(beanClass);
        if (bean == null) {
            throw new ConfigurationException("An unexpected exception occurred: [Can't get bean with given type: [{}]]", new Object[]{beanClass.getName()});
        }
        handlerMapping.setAction(bean);
        this.setInterceptor(beanClass, method, handlerMapping);
        return handlerMapping;
    }

    private byte returnType(Method method, Class<?> returnType, boolean restful) {
        if (Object.class == returnType) {
            return 7;
        }
        if (Image.class.isAssignableFrom(returnType) || RenderedImage.class.isAssignableFrom(returnType)) {
            return 4;
        }
        if (File.class == returnType) {
            return 3;
        }
        if (Void.TYPE == returnType) {
            return 0;
        }
        ResponseBody annotation = method.getAnnotation(ResponseBody.class);
        if (annotation != null) {
            restful = annotation.value();
        }
        if (ModelAndView.class == returnType) {
            return 6;
        }
        if (returnType == StringBuilder.class || returnType == StringBuffer.class) {
            return 5;
        }
        if (String.class == returnType) {
            if (restful) {
                return 5;
            }
            return 2;
        }
        return 1;
    }

    private void setMethodParameter(Parameter[] parameters, List<MethodParameter> methodParameters, Method method) throws IOException {
        String[] methodArgsNames = ClassUtils.getMethodArgsNames((Method)method);
        for (int i = 0; i < parameters.length; ++i) {
            methodParameters.add(this.createMethodParameter(parameters[i], methodArgsNames[i]));
        }
    }

    private MethodParameter createMethodParameter(Parameter parameter, String methodArgsName) {
        Collection requestParams;
        ParameterizedType paramType;
        Class genericityClass = null;
        String parameterName = "";
        int parameterType = 0;
        Class<?> parameterClass = parameter.getType();
        boolean required = false;
        String defaultValue = null;
        byte annotation = 0;
        if (Set.class.isAssignableFrom(parameterClass)) {
            parameterType = 15;
            paramType = (ParameterizedType)parameter.getParameterizedType();
            genericityClass = (Class)paramType.getActualTypeArguments()[0];
        } else if (List.class.isAssignableFrom(parameterClass)) {
            parameterType = 16;
            paramType = (ParameterizedType)parameter.getParameterizedType();
            genericityClass = (Class)paramType.getActualTypeArguments()[0];
        } else if (Map.class.isAssignableFrom(parameterClass) && !Model.class.isAssignableFrom(parameterClass)) {
            parameterType = 14;
            paramType = (ParameterizedType)parameter.getParameterizedType();
            genericityClass = (Class)paramType.getActualTypeArguments()[1];
            if (genericityClass == Object.class) {
                parameterType = 18;
            }
        } else if (parameterClass == Integer.TYPE || parameterClass == Integer.class) {
            parameterType = 3;
        } else if (parameterClass == Long.TYPE || parameterClass == Long.class) {
            parameterType = 5;
        } else if (parameterClass == Short.TYPE || parameterClass == Short.class) {
            parameterType = 4;
        } else if (parameterClass == Byte.TYPE || parameterClass == Byte.class) {
            parameterType = 2;
        } else if (parameterClass == Double.TYPE || parameterClass == Double.class) {
            parameterType = 6;
        } else if (parameterClass == Float.TYPE || parameterClass == Float.class) {
            parameterType = 7;
        } else if (parameterClass == Boolean.TYPE || parameterClass == Boolean.class) {
            parameterType = 9;
        } else if (parameterClass == HttpServletRequest.class) {
            parameterType = 12;
        } else if (parameterClass == HttpServletResponse.class) {
            parameterType = 13;
        } else if (parameterClass == HttpSession.class) {
            parameterType = 10;
        } else if (parameterClass == ServletContext.class) {
            parameterType = 11;
        } else if (parameterClass == Model.class || parameterClass == ModelAttributes.class) {
            parameterType = 18;
        } else if (parameterClass == String.class) {
            parameterType = 8;
        } else if (MultipartFile.class.isAssignableFrom(parameterClass)) {
            parameterType = 21;
        } else if (RedirectModel.class.isAssignableFrom(parameterClass)) {
            parameterType = 23;
        } else if (ModelAndView.class == parameterClass) {
            parameterType = 22;
        }
        if (parameterClass.isArray()) {
            parameterType = 1;
            if (parameterClass.getComponentType() == MultipartFile.class) {
                parameterType = (byte)(parameterType + 21);
            }
        }
        if (genericityClass == MultipartFile.class) {
            parameterType = (byte)(parameterType + 21);
        }
        if (!(requestParams = ClassUtils.getAnnotation((AnnotatedElement)parameter, RequestParam.class)).isEmpty()) {
            RequestParam requestParam = (RequestParam)requestParams.iterator().next();
            annotation = requestParam.type();
            required = requestParam.required();
            parameterName = requestParam.value();
            defaultValue = requestParam.defaultValue();
        }
        if (StringUtils.isEmpty(defaultValue) && NumberUtils.isNumber(parameter.getType())) {
            defaultValue = "0";
        }
        if (StringUtils.isEmpty((String)parameterName)) {
            parameterName = methodArgsName;
        }
        return new MethodParameter(required, parameterName, parameterClass, genericityClass, annotation, defaultValue, (byte)parameterType);
    }

    private void setInterceptor(Class<?> controllerClass, Method action, HandlerMapping requestMapping) {
        int length = 0;
        Integer[] classInterceptor = new Integer[]{};
        Interceptor interceptors = controllerClass.getAnnotation(Interceptor.class);
        if (interceptors != null) {
            Class<? extends HandlerInterceptor>[] values = interceptors.value();
            length = interceptors.value().length;
            classInterceptor = this.addInterceptors(values);
        }
        Interceptor interceptors_ = action.getAnnotation(Interceptor.class);
        Integer[] methodInterceptor = new Integer[]{};
        if (interceptors_ != null) {
            Class<? extends HandlerInterceptor>[] values = interceptors_.value();
            length += interceptors_.value().length;
            methodInterceptor = this.addInterceptors(values);
        }
        Integer[] ids = new Integer[length];
        System.arraycopy(classInterceptor, 0, ids, 0, classInterceptor.length);
        System.arraycopy(methodInterceptor, 0, ids, classInterceptor.length, methodInterceptor.length);
        requestMapping.setInterceptors(ids);
    }

    private final Integer[] addInterceptors(Class<HandlerInterceptor>[] interceptors) {
        Integer[] ids = new Integer[interceptors.length];
        int i = 0;
        for (Class<HandlerInterceptor> interceptor : interceptors) {
            int size = this.handlerInterceptorRegistry.size();
            try {
                int index = this.handlerInterceptorRegistry.indexOf(interceptor);
                if (index >= 0) {
                    ids[i++] = index;
                    continue;
                }
                Object newInstance = this.applicationContext.refresh(this.beanDefinitionLoader.createBeanDefinition(interceptor));
                if (this.handlerInterceptorRegistry.add((HandlerInterceptor)newInstance)) {
                    ids[i++] = size;
                    continue;
                }
                throw new ConfigurationException("Interceptor: [{}] register error", new Object[]{interceptor.getName()});
            }
            catch (Exception e) {
                throw new ConfigurationException("Interceptor: [{}] register error", new Object[]{interceptor.getName(), e});
            }
        }
        return ids;
    }

    @Override
    public void setWebApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.contextPath = applicationContext.getServletContext().getContextPath();
        ConfigurableEnvironment environment = this.applicationContext.getEnvironment();
        this.variables = environment.getProperties();
        this.beanDefinitionLoader = environment.getBeanDefinitionLoader();
    }

    public void destroy() throws Exception {
        if (this.regexUrls != null) {
            this.regexUrls.clear();
        }
        if (this.requestMappings != null) {
            this.requestMappings.clear();
        }
        this.regexUrls = null;
        this.requestMappings = null;
    }

    @Override
    public void onStartup(ServletContext servletContext) throws Throwable {
        this.configuration();
    }

    @Override
    public int getOrder() {
        return 1073741724;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

