/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web;

import cn.taketoday.context.StandardApplicationContext;
import cn.taketoday.context.aware.Aware;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.BeanPostProcessor;
import cn.taketoday.web.ServletContextAware;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.WebApplicationContextAware;
import java.util.Set;
import javax.servlet.ServletContext;

public class DefaultWebApplicationContext
extends StandardApplicationContext
implements WebApplicationContext {
    private ServletContext servletContext;

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public DefaultWebApplicationContext() {
    }

    public DefaultWebApplicationContext(ServletContext servletContext) {
        this();
        this.servletContext = servletContext;
        this.loadContext();
    }

    public DefaultWebApplicationContext(Set<Class<?>> classes, ServletContext servletContext) {
        this();
        this.servletContext = servletContext;
        this.loadContext(classes);
    }

    public DefaultWebApplicationContext(ServletContext servletContext, String properties, String ... locations) {
        super(properties);
        this.servletContext = servletContext;
        this.loadContext(locations);
    }

    protected void postProcessBeanFactory(AbstractBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, BeanDefinition beanDefinition) throws Exception {
                if (bean instanceof Aware) {
                    if (bean instanceof ServletContextAware) {
                        ((ServletContextAware)bean).setServletContext(DefaultWebApplicationContext.this.servletContext);
                    }
                    if (bean instanceof WebApplicationContextAware) {
                        ((WebApplicationContextAware)bean).setWebApplicationContext(DefaultWebApplicationContext.this);
                    }
                }
                return bean;
            }
        });
    }
}

