/*
 * Decompiled with CFR 0.152.
 */
package infra.test.testcontainers;

import org.testcontainers.utility.DockerImageName;

public final class DockerImageNames {
    private static final String ACTIVE_MQ_VERSION = "5.18.0";
    private static final String CASSANDRA_VERSION = "3.11.10";
    private static final String COUCHBASE_VERSION = "7.1.4";
    private static final String ELASTICSEARCH_VERSION = "7.17.5";
    private static final String ELASTICSEARCH_8_VERSION = "8.6.1";
    private static final String KAFKA_VERSION = "7.4.0";
    private static final String MARIADB_VERSION = "10.10";
    private static final String MONGO_VERSION = "5.0.17";
    private static final String MYSQL_VERSION = "8.0";
    private static final String NEO4J_VERSION = "4.4.11";
    private static final String ORACLE_XE_VERSION = "18.4.0-slim";
    private static final String POSTGRESQL_VERSION = "14.0";
    private static final String RABBIT_VERSION = "3.11-alpine";
    private static final String REDIS_VERSION = "7.0.11";
    private static final String REDPANDA_VERSION = "v23.1.2";
    private static final String REGISTRY_VERSION = "2.7.1";
    private static final String ZIPKIN_VERSION = "2.24.1";

    private DockerImageNames() {
    }

    public static DockerImageName activeMq() {
        return DockerImageName.parse((String)"symptoma/activemq").withTag(ACTIVE_MQ_VERSION);
    }

    public static DockerImageName cassandra() {
        return DockerImageName.parse((String)"cassandra").withTag(CASSANDRA_VERSION);
    }

    public static DockerImageName couchbase() {
        return DockerImageName.parse((String)"couchbase/server").withTag(COUCHBASE_VERSION);
    }

    public static DockerImageName elasticsearch() {
        return DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch").withTag(ELASTICSEARCH_VERSION);
    }

    public static DockerImageName elasticsearch8() {
        return DockerImageName.parse((String)"elasticsearch").withTag(ELASTICSEARCH_8_VERSION);
    }

    public static DockerImageName kafka() {
        return DockerImageName.parse((String)"confluentinc/cp-kafka").withTag(KAFKA_VERSION);
    }

    public static DockerImageName mariadb() {
        return DockerImageName.parse((String)"mariadb").withTag(MARIADB_VERSION);
    }

    public static DockerImageName mongo() {
        return DockerImageName.parse((String)"mongo").withTag(MONGO_VERSION);
    }

    public static DockerImageName mysql() {
        return DockerImageName.parse((String)"mysql").withTag(MYSQL_VERSION);
    }

    public static DockerImageName neo4j() {
        return DockerImageName.parse((String)"neo4j").withTag(NEO4J_VERSION);
    }

    public static DockerImageName oracleXe() {
        return DockerImageName.parse((String)"gvenzl/oracle-xe").withTag(ORACLE_XE_VERSION);
    }

    public static DockerImageName postgresql() {
        return DockerImageName.parse((String)"postgres").withTag(POSTGRESQL_VERSION);
    }

    public static DockerImageName rabbit() {
        return DockerImageName.parse((String)"rabbitmq").withTag(RABBIT_VERSION);
    }

    public static DockerImageName redis() {
        return DockerImageName.parse((String)"redis").withTag(REDIS_VERSION);
    }

    public static DockerImageName redpanda() {
        return DockerImageName.parse((String)"redpandadata/redpanda").withTag(REDPANDA_VERSION).asCompatibleSubstituteFor("docker.redpanda.com/redpandadata/redpanda");
    }

    public static DockerImageName sqlserver() {
        return DockerImageName.parse((String)"mcr.microsoft.com/mssql/server");
    }

    public static DockerImageName registry() {
        return DockerImageName.parse((String)"registry").withTag(REGISTRY_VERSION);
    }

    public static DockerImageName zipkin() {
        return DockerImageName.parse((String)"openzipkin/zipkin").withTag(ZIPKIN_VERSION);
    }
}

