/*
 * Decompiled with CFR 0.152.
 */
package infra.test.process;

import infra.core.annotation.MergedAnnotations;
import infra.lang.Assert;
import infra.test.process.DisabledIfProcessUnavailable;
import infra.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

class DisabledIfProcessUnavailableCondition
implements ExecutionCondition {
    private static final String USR_LOCAL_BIN = "/usr/local/bin";
    private static final boolean MAC_OS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac");

    DisabledIfProcessUnavailableCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        ArrayList commands = new ArrayList();
        context.getTestClass().map(this::getAnnotationValue).orElse(Stream.empty()).forEach(commands::add);
        context.getTestMethod().map(this::getAnnotationValue).orElse(Stream.empty()).forEach(commands::add);
        try {
            commands.forEach(this::check);
            return ConditionEvaluationResult.enabled((String)"All processes available");
        }
        catch (Throwable ex) {
            return ConditionEvaluationResult.disabled((String)"Process unavailable", (String)ex.getMessage());
        }
    }

    private Stream<String[]> getAnnotationValue(AnnotatedElement testElement) {
        return MergedAnnotations.from((AnnotatedElement)testElement, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(DisabledIfProcessUnavailable.class).map(annotation -> annotation.getStringArray("value"));
    }

    private void check(String[] command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            process.waitFor();
            Assert.state((process.exitValue() == 0 ? 1 : 0) != 0, () -> "Process exited with %d".formatted(process.exitValue()));
            process.destroy();
        }
        catch (Exception ex) {
            String path = processBuilder.environment().get("PATH");
            if (MAC_OS && path != null && !path.contains(USR_LOCAL_BIN) && !command[0].startsWith("/usr/local/bin/")) {
                String[] localCommand = (String[])command.clone();
                localCommand[0] = "/usr/local/bin/" + localCommand[0];
                this.check(localCommand);
                return;
            }
            throw new IllegalStateException("Unable to start process '%s'".formatted(StringUtils.arrayToDelimitedString((Object[])command, (String)" ")));
        }
    }
}

