/*
 * Decompiled with CFR 0.152.
 */
package infra.test.junit;

import infra.core.annotation.MergedAnnotation;
import infra.core.annotation.MergedAnnotations;
import infra.test.junit.DisabledOnOs;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

class DisabledOnOsCondition
implements ExecutionCondition {
    DisabledOnOsCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (context.getElement().isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"No element for @DisabledOnOs found");
        }
        MergedAnnotation annotation = MergedAnnotations.from((AnnotatedElement)((AnnotatedElement)context.getElement().get()), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(DisabledOnOs.class);
        if (!annotation.isPresent()) {
            return ConditionEvaluationResult.enabled((String)"No @DisabledOnOs found");
        }
        return this.evaluate((DisabledOnOs)annotation.synthesize());
    }

    private ConditionEvaluationResult evaluate(DisabledOnOs annotation) {
        String architecture = System.getProperty("os.arch");
        String os = System.getProperty("os.name");
        boolean onDisabledOs = Arrays.stream(annotation.os()).anyMatch(OS::isCurrentOs);
        boolean onDisabledArchitecture = Arrays.asList(annotation.architecture()).contains(architecture);
        if (onDisabledOs && onDisabledArchitecture) {
            String reason = annotation.disabledReason().isEmpty() ? String.format("Disabled on OS = %s, architecture = %s", os, architecture) : annotation.disabledReason();
            return ConditionEvaluationResult.disabled((String)reason);
        }
        return ConditionEvaluationResult.enabled((String)String.format("Enabled on OS = %s, architecture = %s", os, architecture));
    }
}

