/*
 * Decompiled with CFR 0.152.
 */
package infra.test.assertj;

import infra.core.task.SimpleAsyncTaskExecutor;
import infra.util.ReflectionUtils;
import java.lang.reflect.Field;
import org.assertj.core.api.AbstractAssert;

public final class SimpleAsyncTaskExecutorAssert
extends AbstractAssert<SimpleAsyncTaskExecutorAssert, SimpleAsyncTaskExecutor> {
    private SimpleAsyncTaskExecutorAssert(SimpleAsyncTaskExecutor actual) {
        super((Object)actual, SimpleAsyncTaskExecutorAssert.class);
    }

    public SimpleAsyncTaskExecutorAssert usesPlatformThreads() {
        this.isNotNull();
        if (this.producesVirtualThreads()) {
            this.failWithMessage("Expected executor to use platform threads, but it uses virtual threads", new Object[0]);
        }
        return this;
    }

    public SimpleAsyncTaskExecutorAssert usesVirtualThreads() {
        this.isNotNull();
        if (!this.producesVirtualThreads()) {
            this.failWithMessage("Expected executor to use virtual threads, but it uses platform threads", new Object[0]);
        }
        return this;
    }

    private boolean producesVirtualThreads() {
        Field field = ReflectionUtils.findField(SimpleAsyncTaskExecutor.class, (String)"virtualThreadDelegate");
        if (field == null) {
            throw new IllegalStateException("Field SimpleAsyncTaskExecutor.virtualThreadDelegate not found");
        }
        ReflectionUtils.makeAccessible((Field)field);
        Object virtualThreadDelegate = ReflectionUtils.getField((Field)field, (Object)this.actual);
        return virtualThreadDelegate != null;
    }

    public static SimpleAsyncTaskExecutorAssert assertThat(SimpleAsyncTaskExecutor actual) {
        return new SimpleAsyncTaskExecutorAssert(actual);
    }
}

