/*
 * Decompiled with CFR 0.152.
 */
package infra.test;

import java.io.File;
import java.net.URISyntaxException;

public class BuildOutput {
    private final Class<?> testClass;

    public BuildOutput(Class<?> testClass) {
        this.testClass = testClass;
    }

    public File getTestClassesLocation() {
        try {
            File location = new File(this.testClass.getProtectionDomain().getCodeSource().getLocation().toURI());
            String path = location.getPath();
            if (path.endsWith(this.path("target", "test-classes")) || path.endsWith(this.path("bin", "test")) || path.endsWith(this.path("bin", "intTest")) || path.endsWith(this.path("build", "classes", "java", "test")) || path.endsWith(this.path("build", "classes", "java", "intTest"))) {
                return location;
            }
            throw new IllegalStateException("Unexpected test classes location '" + location + "'");
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Invalid test class code source location", ex);
        }
    }

    public File getTestResourcesLocation() {
        File testClassesLocation = this.getTestClassesLocation();
        String path = testClassesLocation.getPath();
        if (path.endsWith(this.path("target", "test-classes")) || path.endsWith(this.path("bin", "test")) || path.endsWith(this.path("bin", "intTest"))) {
            return testClassesLocation;
        }
        if (path.endsWith(this.path("build", "classes", "java", "test"))) {
            return new File(testClassesLocation.getParentFile().getParentFile().getParentFile(), "resources/test");
        }
        if (path.endsWith(this.path("build", "classes", "java", "intTest"))) {
            return new File(testClassesLocation.getParentFile().getParentFile().getParentFile(), "resources/intTest");
        }
        throw new IllegalStateException("Cannot determine test resources location from classes location '" + testClassesLocation + "'");
    }

    public File getRootLocation() {
        return new File("build");
    }

    private String path(String ... components) {
        return File.separator + String.join((CharSequence)File.separator, components);
    }
}

