/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test.web.servlet;

import cn.taketoday.mock.web.MockSessionCookieConfig;
import cn.taketoday.util.ExceptionUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public abstract class MockServletWebServer {
    private ServletContext servletContext;
    private final Initializer[] initializers;
    private final List<RegisteredServlet> registeredServlets = new ArrayList<RegisteredServlet>();
    private final List<RegisteredFilter> registeredFilters = new ArrayList<RegisteredFilter>();
    private final int port;

    public MockServletWebServer(Initializer[] initializers, int port) {
        this.initializers = initializers;
        this.port = port;
        this.initialize();
    }

    private void initialize() {
        try {
            this.servletContext = (ServletContext)Mockito.mock(ServletContext.class);
            ((ServletContext)Mockito.lenient().doAnswer(invocation -> {
                RegisteredServlet registeredServlet = new RegisteredServlet((Servlet)invocation.getArgument(1));
                this.registeredServlets.add(registeredServlet);
                return registeredServlet.getRegistration();
            }).when((Object)this.servletContext)).addServlet(ArgumentMatchers.anyString(), (Servlet)ArgumentMatchers.any(Servlet.class));
            ((ServletContext)Mockito.lenient().doAnswer(invocation -> {
                RegisteredFilter registeredFilter = new RegisteredFilter((Filter)invocation.getArgument(1));
                this.registeredFilters.add(registeredFilter);
                return registeredFilter.getRegistration();
            }).when((Object)this.servletContext)).addFilter(ArgumentMatchers.anyString(), (Filter)ArgumentMatchers.any(Filter.class));
            MockSessionCookieConfig sessionCookieConfig = new MockSessionCookieConfig();
            BDDMockito.given((Object)this.servletContext.getSessionCookieConfig()).willReturn((Object)sessionCookieConfig);
            HashMap initParameters = new HashMap();
            ((ServletContext)Mockito.lenient().doAnswer(invocation -> {
                initParameters.put((String)invocation.getArgument(0), (String)invocation.getArgument(1));
                return null;
            }).when((Object)this.servletContext)).setInitParameter(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
            Mockito.lenient().when((Object)this.servletContext.getInitParameterNames()).thenReturn(Collections.enumeration(initParameters.keySet()));
            ((ServletContext)Mockito.lenient().doAnswer(invocation -> initParameters.get(invocation.getArgument(0))).when((Object)this.servletContext)).getInitParameter(ArgumentMatchers.anyString());
            Mockito.lenient().when((Object)this.servletContext.getAttributeNames()).thenReturn(Collections.emptyEnumeration());
            for (Initializer initializer : this.initializers) {
                initializer.onStartup(this.servletContext);
            }
        }
        catch (ServletException ex) {
            throw ExceptionUtils.sneakyThrow((Throwable)ex);
        }
    }

    public void stop() {
        this.servletContext = null;
        this.registeredServlets.clear();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Servlet[] getServlets() {
        Servlet[] servlets = new Servlet[this.registeredServlets.size()];
        Arrays.setAll(servlets, i -> this.registeredServlets.get(i).getServlet());
        return servlets;
    }

    public RegisteredServlet getRegisteredServlet(int index) {
        return this.getRegisteredServlets().get(index);
    }

    public List<RegisteredServlet> getRegisteredServlets() {
        return this.registeredServlets;
    }

    public RegisteredFilter getRegisteredFilters(int index) {
        return this.getRegisteredFilters().get(index);
    }

    public List<RegisteredFilter> getRegisteredFilters() {
        return this.registeredFilters;
    }

    public int getPort() {
        return this.port;
    }

    @FunctionalInterface
    protected static interface Initializer {
        public void onStartup(ServletContext var1) throws ServletException;
    }

    public static class RegisteredServlet {
        private final Servlet servlet;
        private final ServletRegistration.Dynamic registration;

        public RegisteredServlet(Servlet servlet) {
            this.servlet = servlet;
            this.registration = (ServletRegistration.Dynamic)Mockito.mock(ServletRegistration.Dynamic.class);
        }

        public ServletRegistration.Dynamic getRegistration() {
            return this.registration;
        }

        public Servlet getServlet() {
            return this.servlet;
        }
    }

    public static class RegisteredFilter {
        private final Filter filter;
        private final FilterRegistration.Dynamic registration;

        public RegisteredFilter(Filter filter) {
            this.filter = filter;
            this.registration = (FilterRegistration.Dynamic)Mockito.mock(FilterRegistration.Dynamic.class);
        }

        public FilterRegistration.Dynamic getRegistration() {
            return this.registration;
        }

        public Filter getFilter() {
            return this.filter;
        }
    }
}

