/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test.web.servlet;

import cn.taketoday.util.StreamUtils;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.OutputStream;

public class ExampleServlet
extends GenericServlet {
    private final boolean echoRequestInfo;
    private final boolean writeWithoutContentLength;

    public ExampleServlet() {
        this(false, false);
    }

    public ExampleServlet(boolean echoRequestInfo, boolean writeWithoutContentLength) {
        this.echoRequestInfo = echoRequestInfo;
        this.writeWithoutContentLength = writeWithoutContentLength;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Object content = "Hello World";
        if (this.echoRequestInfo) {
            content = (String)content + " scheme=" + request.getScheme();
            content = (String)content + " remoteaddr=" + request.getRemoteAddr();
        }
        if (this.writeWithoutContentLength) {
            response.setContentType("text/plain");
            ServletOutputStream outputStream = response.getOutputStream();
            StreamUtils.copy((byte[])((String)content).getBytes(), (OutputStream)outputStream);
            outputStream.flush();
        } else {
            response.getWriter().write((String)content);
        }
    }
}

