/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test.web.servlet;

import cn.taketoday.test.util.ReflectionTestUtils;
import cn.taketoday.util.ClassUtils;
import java.lang.reflect.InaccessibleObjectException;
import java.net.URL;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

class DirtiesUrlFactoriesExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final String TOMCAT_URL_STREAM_HANDLER_FACTORY = "org.apache.catalina.webresources.TomcatURLStreamHandlerFactory";

    DirtiesUrlFactoriesExtension() {
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.reset();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.reset();
    }

    private void reset() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (ClassUtils.isPresent((String)TOMCAT_URL_STREAM_HANDLER_FACTORY, (ClassLoader)classLoader)) {
                Class factoryClass = ClassUtils.resolveClassName((String)TOMCAT_URL_STREAM_HANDLER_FACTORY, (ClassLoader)classLoader);
                ReflectionTestUtils.setField((Class)factoryClass, (String)"instance", null);
            }
            ReflectionTestUtils.setField(URL.class, (String)"factory", null);
        }
        catch (InaccessibleObjectException ex) {
            throw new IllegalStateException("Unable to reset field. Please run with '--add-opens=java.base/java.net=ALL-UNNAMED'", ex);
        }
    }
}

