/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test.testcontainers;

import org.elasticsearch.Version;
import org.testcontainers.utility.DockerImageName;

public final class DockerImageNames {
    private static final String CASSANDRA_VERSION = "3.11.10";
    private static final String COUCHBASE_VERSION = "6.5.1";
    private static final String MONGO_VERSION = "4.0.23";
    private static final String NEO4J_VERSION = "4.0";
    private static final String POSTGRESQL_VERSION = "14.0";
    private static final String REDIS_VERSION = "4.0.14";
    private static final String REGISTRY_VERSION = "2.7.1";

    private DockerImageNames() {
    }

    public static DockerImageName cassandra() {
        return DockerImageName.parse((String)"cassandra").withTag(CASSANDRA_VERSION);
    }

    public static DockerImageName couchbase() {
        return DockerImageName.parse((String)"couchbase/server").withTag(COUCHBASE_VERSION);
    }

    public static DockerImageName elasticsearch() {
        String version = Version.CURRENT.toString();
        return DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch").withTag(version);
    }

    public static DockerImageName mongo() {
        return DockerImageName.parse((String)"mongo").withTag(MONGO_VERSION);
    }

    public static DockerImageName neo4j() {
        return DockerImageName.parse((String)"neo4j").withTag(NEO4J_VERSION);
    }

    public static DockerImageName postgresql() {
        return DockerImageName.parse((String)"postgres").withTag(POSTGRESQL_VERSION);
    }

    public static DockerImageName redis() {
        return DockerImageName.parse((String)"redis").withTag(REDIS_VERSION);
    }

    public static DockerImageName registry() {
        return DockerImageName.parse((String)"registry").withTag(REGISTRY_VERSION);
    }
}

