/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test.testcontainers;

import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.DockerClientFactory;

class DisabledIfDockerUnavailableCondition
implements ExecutionCondition {
    private static final String SILENCE_PROPERTY = "visibleassertions.silence";
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"Docker available");
    private static final ConditionEvaluationResult DISABLED = ConditionEvaluationResult.disabled((String)"Docker unavailable");

    DisabledIfDockerUnavailableCondition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        String originalSilenceValue = System.getProperty(SILENCE_PROPERTY);
        try {
            DockerClientFactory.instance().client();
            ConditionEvaluationResult conditionEvaluationResult = ENABLED;
            return conditionEvaluationResult;
        }
        catch (Throwable ex) {
            ConditionEvaluationResult conditionEvaluationResult = DISABLED;
            return conditionEvaluationResult;
        }
        finally {
            if (originalSilenceValue != null) {
                System.setProperty(SILENCE_PROPERTY, originalSilenceValue);
            } else {
                System.clearProperty(SILENCE_PROPERTY);
            }
        }
    }
}

