/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test.junit;

import cn.taketoday.test.junit.DisabledOnOs;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

class DisabledOnOsCondition
implements ExecutionCondition {
    DisabledOnOsCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional annotation = AnnotationUtils.findAnnotation((Optional)context.getElement(), DisabledOnOs.class);
        if (annotation.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"No @DisabledOnOs found");
        }
        return this.evaluate((DisabledOnOs)annotation.get());
    }

    private ConditionEvaluationResult evaluate(DisabledOnOs annotation) {
        String architecture = System.getProperty("os.arch");
        String os = System.getProperty("os.name");
        if (annotation.os().isCurrentOs() && annotation.architecture().equals(architecture)) {
            String reason = annotation.disabledReason().isEmpty() ? String.format("Disabled on OS = %s, architecture = %s", os, architecture) : annotation.disabledReason();
            return ConditionEvaluationResult.disabled((String)reason);
        }
        return ConditionEvaluationResult.enabled((String)String.format("Enabled on OS = %s, architecture = %s", os, architecture));
    }
}

