/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class TestCompiler {
    public static final File SOURCE_DIRECTORY = new File("src/test/java");
    private final JavaCompiler compiler;
    private final StandardJavaFileManager fileManager;
    private final File outputLocation;

    public TestCompiler(File outputLocation) throws IOException {
        this(ToolProvider.getSystemJavaCompiler(), outputLocation);
    }

    public TestCompiler(JavaCompiler compiler, File outputLocation) throws IOException {
        this.compiler = compiler;
        this.fileManager = compiler.getStandardFileManager(null, null, null);
        this.outputLocation = outputLocation;
        this.outputLocation.mkdirs();
        List<File> temp = Collections.singletonList(this.outputLocation);
        this.fileManager.setLocation(StandardLocation.CLASS_OUTPUT, temp);
        this.fileManager.setLocation(StandardLocation.SOURCE_OUTPUT, temp);
    }

    public TestCompilationTask getTask(Collection<File> sourceFiles) {
        Iterable<? extends JavaFileObject> javaFileObjects = this.fileManager.getJavaFileObjectsFromFiles(sourceFiles);
        return this.getTask(javaFileObjects);
    }

    public TestCompilationTask getTask(Class<?> ... types) {
        Iterable<? extends JavaFileObject> javaFileObjects = this.getJavaFileObjects(types);
        return this.getTask(javaFileObjects);
    }

    private TestCompilationTask getTask(Iterable<? extends JavaFileObject> javaFileObjects) {
        return new TestCompilationTask(this.compiler.getTask(null, this.fileManager, null, null, null, javaFileObjects));
    }

    public File getOutputLocation() {
        return this.outputLocation;
    }

    private Iterable<? extends JavaFileObject> getJavaFileObjects(Class<?> ... types) {
        File[] files = new File[types.length];
        for (int i = 0; i < types.length; ++i) {
            files[i] = this.getFile(types[i]);
        }
        return this.fileManager.getJavaFileObjects(files);
    }

    protected File getFile(Class<?> type) {
        return new File(this.getSourceDirectory(), TestCompiler.sourcePathFor(type));
    }

    public static String sourcePathFor(Class<?> type) {
        return type.getName().replace('.', '/') + ".java";
    }

    protected File getSourceDirectory() {
        return SOURCE_DIRECTORY;
    }

    public static class TestCompilationTask {
        private final JavaCompiler.CompilationTask task;

        public TestCompilationTask(JavaCompiler.CompilationTask task) {
            this.task = task;
        }

        public void call(Processor ... processors) {
            this.task.setProcessors(Arrays.asList(processors));
            if (!this.task.call().booleanValue()) {
                throw new IllegalStateException("Compilation failed");
            }
        }
    }
}

