/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.test;

import java.io.File;
import java.net.URISyntaxException;

public class BuildOutput {
    private final Class<?> testClass;

    public BuildOutput(Class<?> testClass) {
        this.testClass = testClass;
    }

    public File getTestClassesLocation() {
        try {
            File location = new File(this.testClass.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (location.getPath().endsWith(this.path("bin", "test")) || location.getPath().endsWith(this.path("bin", "intTest")) || location.getPath().endsWith(this.path("build", "classes", "java", "test")) || location.getPath().endsWith(this.path("build", "classes", "java", "intTest"))) {
                return location;
            }
            throw new IllegalStateException("Unexpected test classes location '" + location + "'");
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Invalid test class code source location", ex);
        }
    }

    public File getTestResourcesLocation() {
        File testClassesLocation = this.getTestClassesLocation();
        if (testClassesLocation.getPath().endsWith(this.path("bin", "test")) || testClassesLocation.getPath().endsWith(this.path("bin", "intTest"))) {
            return testClassesLocation;
        }
        if (testClassesLocation.getPath().endsWith(this.path("build", "classes", "java", "test"))) {
            return new File(testClassesLocation.getParentFile().getParentFile().getParentFile(), "resources/test");
        }
        if (testClassesLocation.getPath().endsWith(this.path("build", "classes", "java", "intTest"))) {
            return new File(testClassesLocation.getParentFile().getParentFile().getParentFile(), "resources/intTest");
        }
        throw new IllegalStateException("Cannot determine test resources location from classes location '" + testClassesLocation + "'");
    }

    public File getRootLocation() {
        return new File("build");
    }

    private String path(String ... components) {
        return File.separator + String.join((CharSequence)File.separator, components);
    }
}

