/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.vendor;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.function.Predicate;
import org.hibernate.bytecode.internal.none.BytecodeProviderImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;

@TargetClass(className="org.hibernate.bytecode.internal.BytecodeProviderInitiator", onlyWith={SubstituteOnlyIfPresent.class})
final class Target_BytecodeProviderInitiator {
    @Alias
    public static String BYTECODE_PROVIDER_NAME_NONE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    public static String BYTECODE_PROVIDER_NAME_DEFAULT;

    Target_BytecodeProviderInitiator() {
    }

    @Substitute
    public static BytecodeProvider buildBytecodeProvider(String providerName) {
        return new BytecodeProviderImpl();
    }

    static {
        BYTECODE_PROVIDER_NAME_DEFAULT = BYTECODE_PROVIDER_NAME_NONE;
    }

    static class SubstituteOnlyIfPresent
    implements Predicate<String> {
        SubstituteOnlyIfPresent() {
        }

        @Override
        public boolean test(String type) {
            try {
                Class<?> clazz = Class.forName(type, false, this.getClass().getClassLoader());
                clazz.getDeclaredMethod("buildBytecodeProvider", String.class);
                clazz.getField("BYTECODE_PROVIDER_NAME_NONE");
                clazz.getField("BYTECODE_PROVIDER_NAME_DEFAULT");
                return true;
            }
            catch (ClassNotFoundException | NoClassDefFoundError | NoSuchFieldException | NoSuchMethodException ex) {
                return false;
            }
        }
    }
}

