/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.vendor;

import cn.taketoday.jdbc.datasource.ConnectionHandle;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.DefaultJpaDialect;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.UnitOfWork;

public class EclipseLinkJpaDialect
extends DefaultJpaDialect {
    private static final long serialVersionUID = 1L;
    private boolean lazyDatabaseTransaction = false;

    public void setLazyDatabaseTransaction(boolean lazyDatabaseTransaction) {
        this.lazyDatabaseTransaction = lazyDatabaseTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        int currentIsolationLevel = definition.getIsolationLevel();
        if (currentIsolationLevel != -1) {
            DatabaseLogin databaseLogin;
            UnitOfWork uow = (UnitOfWork)entityManager.unwrap(UnitOfWork.class);
            DatabaseLogin databaseLogin2 = databaseLogin = uow.getLogin();
            synchronized (databaseLogin2) {
                int originalIsolationLevel = databaseLogin.getTransactionIsolation();
                if (currentIsolationLevel != originalIsolationLevel) {
                    databaseLogin.setTransactionIsolation(currentIsolationLevel);
                }
                entityManager.getTransaction().begin();
                uow.beginEarlyTransaction();
                entityManager.unwrap(Connection.class);
                if (currentIsolationLevel != originalIsolationLevel) {
                    databaseLogin.setTransactionIsolation(originalIsolationLevel);
                }
            }
        } else if (!definition.isReadOnly() && !this.lazyDatabaseTransaction) {
            DatabaseLogin databaseLogin;
            UnitOfWork uow = (UnitOfWork)entityManager.unwrap(UnitOfWork.class);
            DatabaseLogin databaseLogin3 = databaseLogin = uow.getLogin();
            synchronized (databaseLogin3) {
                entityManager.getTransaction().begin();
                uow.beginEarlyTransaction();
                entityManager.unwrap(Connection.class);
            }
        } else {
            entityManager.getTransaction().begin();
        }
        return null;
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return new EclipseLinkConnectionHandle(entityManager);
    }

    private static class EclipseLinkConnectionHandle
    implements ConnectionHandle {
        private final EntityManager entityManager;
        @Nullable
        private Connection connection;

        public EclipseLinkConnectionHandle(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Connection getConnection() {
            if (this.connection == null) {
                this.connection = (Connection)this.entityManager.unwrap(Connection.class);
            }
            return this.connection;
        }
    }
}

