/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.support;

import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.EntityManagerFactoryAccessor;
import cn.taketoday.orm.jpa.EntityManagerFactoryInfo;
import cn.taketoday.orm.jpa.SharedEntityManagerCreator;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;

public class SharedEntityManagerBean
extends EntityManagerFactoryAccessor
implements FactoryBean<EntityManager>,
InitializingBean {
    @Nullable
    private Class<? extends EntityManager> entityManagerInterface;
    private boolean synchronizedWithTransaction = true;
    @Nullable
    private EntityManager shared;

    public void setEntityManagerInterface(Class<? extends EntityManager> entityManagerInterface) {
        Assert.notNull(entityManagerInterface, (String)"'entityManagerInterface' is required");
        this.entityManagerInterface = entityManagerInterface;
    }

    public void setSynchronizedWithTransaction(boolean synchronizedWithTransaction) {
        this.synchronizedWithTransaction = synchronizedWithTransaction;
    }

    public final void afterPropertiesSet() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf == null) {
            throw new IllegalArgumentException("'entityManagerFactory' or 'persistenceUnitName' is required");
        }
        if (emf instanceof EntityManagerFactoryInfo) {
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = emfInfo.getEntityManagerInterface();
                if (this.entityManagerInterface == null) {
                    this.entityManagerInterface = EntityManager.class;
                }
            }
        } else if (this.entityManagerInterface == null) {
            this.entityManagerInterface = EntityManager.class;
        }
        this.shared = SharedEntityManagerCreator.createSharedEntityManager(emf, this.getJpaPropertyMap(), this.synchronizedWithTransaction, this.entityManagerInterface);
    }

    @Nullable
    public EntityManager getObject() {
        return this.shared;
    }

    public Class<? extends EntityManager> getObjectType() {
        return this.entityManagerInterface != null ? this.entityManagerInterface : EntityManager.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

