/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.persistenceunit;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import jakarta.persistence.spi.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;

class ClassFileTransformerAdapter
implements ClassFileTransformer {
    private static final Logger log = LoggerFactory.getLogger(ClassFileTransformerAdapter.class);
    private final ClassTransformer classTransformer;
    private boolean currentlyTransforming = false;

    public ClassFileTransformerAdapter(ClassTransformer classTransformer) {
        Assert.notNull((Object)classTransformer, (String)"ClassTransformer is required");
        this.classTransformer = classTransformer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassFileTransformerAdapter classFileTransformerAdapter = this;
        synchronized (classFileTransformerAdapter) {
            if (this.currentlyTransforming) {
                return null;
            }
            this.currentlyTransforming = true;
            try {
                byte[] transformed = this.classTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                if (transformed != null && log.isDebugEnabled()) {
                    log.debug("Transformer of class [{}] transformed class [{}]; bytes in={}; bytes out={}", new Object[]{this.classTransformer.getClass().getName(), className, classfileBuffer.length, transformed.length});
                }
                byte[] byArray = transformed;
                return byArray;
            }
            catch (ClassCircularityError ex) {
                if (log.isErrorEnabled()) {
                    log.error("Circularity error while weaving class [{}] with transformer of class [{}]", (Object)className, (Object)this.classTransformer.getClass().getName(), (Throwable)ex);
                }
                throw new IllegalStateException("Failed to weave class [" + className + "]", ex);
            }
            catch (Throwable ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Error weaving class [{}] with transformer of class [{}]", new Object[]{className, this.classTransformer.getClass().getName(), ex});
                }
                throw new IllegalStateException("Could not weave class [" + className + "]", ex);
            }
            finally {
                this.currentlyTransforming = false;
            }
        }
    }

    public String toString() {
        return "Standard ClassFileTransformer wrapping JPA transformer: " + this.classTransformer;
    }
}

