/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.context.ResourceLoaderAware;
import cn.taketoday.context.weaving.LoadTimeWeaverAware;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.instrument.classloading.LoadTimeWeaver;
import cn.taketoday.jdbc.datasource.lookup.DataSourceLookup;
import cn.taketoday.jdbc.datasource.lookup.SingleDataSourceLookup;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.AbstractEntityManagerFactoryBean;
import cn.taketoday.orm.jpa.JpaVendorAdapter;
import cn.taketoday.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import cn.taketoday.orm.jpa.persistenceunit.PersistenceManagedTypes;
import cn.taketoday.orm.jpa.persistenceunit.PersistenceUnitManager;
import cn.taketoday.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import cn.taketoday.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import cn.taketoday.util.ClassUtils;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;

public class LocalContainerEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean
implements ResourceLoaderAware,
LoadTimeWeaverAware {
    @Nullable
    private PersistenceUnitManager persistenceUnitManager;
    private final DefaultPersistenceUnitManager internalPersistenceUnitManager = new DefaultPersistenceUnitManager();
    @Nullable
    private PersistenceUnitInfo persistenceUnitInfo;

    public void setPersistenceUnitManager(PersistenceUnitManager persistenceUnitManager) {
        this.persistenceUnitManager = persistenceUnitManager;
    }

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.internalPersistenceUnitManager.setPersistenceXmlLocation(persistenceXmlLocation);
    }

    @Override
    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        super.setPersistenceUnitName(persistenceUnitName);
        if (persistenceUnitName != null) {
            this.internalPersistenceUnitManager.setDefaultPersistenceUnitName(persistenceUnitName);
        }
    }

    public void setPersistenceUnitRootLocation(String defaultPersistenceUnitRootLocation) {
        this.internalPersistenceUnitManager.setDefaultPersistenceUnitRootLocation(defaultPersistenceUnitRootLocation);
    }

    public void setManagedTypes(PersistenceManagedTypes managedTypes) {
        this.internalPersistenceUnitManager.setManagedTypes(managedTypes);
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.internalPersistenceUnitManager.setPackagesToScan(packagesToScan);
    }

    public void setMappingResources(String ... mappingResources) {
        this.internalPersistenceUnitManager.setMappingResources(mappingResources);
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.internalPersistenceUnitManager.setSharedCacheMode(sharedCacheMode);
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.internalPersistenceUnitManager.setValidationMode(validationMode);
    }

    public void setDataSource(@Nullable DataSource dataSource) {
        this.internalPersistenceUnitManager.setDataSourceLookup((DataSourceLookup)(dataSource != null ? new SingleDataSourceLookup(dataSource) : null));
        this.internalPersistenceUnitManager.setDefaultDataSource(dataSource);
    }

    public void setJtaDataSource(@Nullable DataSource jtaDataSource) {
        this.internalPersistenceUnitManager.setDataSourceLookup((DataSourceLookup)(jtaDataSource != null ? new SingleDataSourceLookup(jtaDataSource) : null));
        this.internalPersistenceUnitManager.setDefaultJtaDataSource(jtaDataSource);
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... postProcessors) {
        this.internalPersistenceUnitManager.setPersistenceUnitPostProcessors(postProcessors);
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.internalPersistenceUnitManager.setLoadTimeWeaver(loadTimeWeaver);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.internalPersistenceUnitManager.setResourceLoader(resourceLoader);
    }

    @Override
    public void afterPropertiesSet() throws PersistenceException {
        String rootPackage;
        PersistenceUnitManager managerToUse = this.persistenceUnitManager;
        if (this.persistenceUnitManager == null) {
            this.internalPersistenceUnitManager.afterPropertiesSet();
            managerToUse = this.internalPersistenceUnitManager;
        }
        this.persistenceUnitInfo = this.determinePersistenceUnitInfo(managerToUse);
        JpaVendorAdapter jpaVendorAdapter = this.getJpaVendorAdapter();
        if (jpaVendorAdapter != null && this.persistenceUnitInfo instanceof SmartPersistenceUnitInfo && (rootPackage = jpaVendorAdapter.getPersistenceProviderRootPackage()) != null) {
            ((SmartPersistenceUnitInfo)this.persistenceUnitInfo).setPersistenceProviderPackageName(rootPackage);
        }
        super.afterPropertiesSet();
    }

    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        Assert.state((this.persistenceUnitInfo != null ? 1 : 0) != 0, (String)"PersistenceUnitInfo not initialized");
        PersistenceProvider provider = this.getPersistenceProvider();
        if (provider == null) {
            String providerClassName = this.persistenceUnitInfo.getPersistenceProviderClassName();
            if (providerClassName == null) {
                throw new IllegalArgumentException("No PersistenceProvider specified in EntityManagerFactory configuration, and chosen PersistenceUnitInfo does not specify a provider class name either");
            }
            Class providerClass = ClassUtils.resolveClassName((String)providerClassName, (ClassLoader)this.getBeanClassLoader());
            provider = (PersistenceProvider)BeanUtils.newInstance((Class)providerClass);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Building JPA container EntityManagerFactory for persistence unit '{}'", (Object)this.persistenceUnitInfo.getPersistenceUnitName());
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(this.persistenceUnitInfo, this.getJpaPropertyMap());
        this.postProcessEntityManagerFactory(emf, this.persistenceUnitInfo);
        return emf;
    }

    protected PersistenceUnitInfo determinePersistenceUnitInfo(PersistenceUnitManager persistenceUnitManager) {
        if (this.getPersistenceUnitName() != null) {
            return persistenceUnitManager.obtainPersistenceUnitInfo(this.getPersistenceUnitName());
        }
        return persistenceUnitManager.obtainDefaultPersistenceUnitInfo();
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
    }

    @Override
    @Nullable
    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    @Override
    @Nullable
    public String getPersistenceUnitName() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getPersistenceUnitName();
        }
        return super.getPersistenceUnitName();
    }

    @Override
    public DataSource getDataSource() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getJtaDataSource() != null ? this.persistenceUnitInfo.getJtaDataSource() : this.persistenceUnitInfo.getNonJtaDataSource();
        }
        return this.internalPersistenceUnitManager.getDefaultJtaDataSource() != null ? this.internalPersistenceUnitManager.getDefaultJtaDataSource() : this.internalPersistenceUnitManager.getDefaultDataSource();
    }
}

