/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa;

import cn.taketoday.dao.DataAccessException;
import cn.taketoday.jdbc.datasource.ConnectionHandle;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.EntityManagerFactoryUtils;
import cn.taketoday.orm.jpa.JpaDialect;
import cn.taketoday.transaction.InvalidIsolationLevelException;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.sql.SQLException;

public class DefaultJpaDialect
implements JpaDialect,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    @Nullable
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException(this.getClass().getSimpleName() + " does not support custom isolation levels due to limitations in standard JPA. Specific arrangements may be implemented in custom JpaDialect variants.");
        }
        entityManager.getTransaction().begin();
        return null;
    }

    @Override
    @Nullable
    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, @Nullable String name) throws PersistenceException {
        return null;
    }

    @Override
    public void cleanupTransaction(@Nullable Object transactionData) {
    }

    @Override
    @Nullable
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return null;
    }

    @Override
    public void releaseJdbcConnection(ConnectionHandle conHandle, EntityManager em) throws PersistenceException, SQLException {
    }

    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }
}

