/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.hibernate5;

import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.core.InfrastructureProxy;
import cn.taketoday.core.io.PathMatchingPatternResourceLoader;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.task.AsyncTaskExecutor;
import cn.taketoday.core.type.classreading.CachingMetadataReaderFactory;
import cn.taketoday.core.type.classreading.ClassFormatException;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.filter.AnnotationTypeFilter;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.lang.TodayStrategies;
import cn.taketoday.orm.hibernate5.ConfigurableJtaPlatform;
import cn.taketoday.orm.hibernate5.HibernateBeanContainer;
import cn.taketoday.orm.hibernate5.HibernateSessionContext;
import cn.taketoday.transaction.jta.JtaTransactionManager;
import cn.taketoday.util.ClassUtils;
import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import jakarta.transaction.TransactionManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.service.ServiceRegistry;

public class LocalSessionFactoryBuilder
extends Configuration {
    public static final String IGNORE_CLASSFORMAT_PROPERTY_NAME = "infra.classformat.ignore";
    private static final boolean shouldIgnoreClassFormatException = TodayStrategies.getFlag((String)"infra.classformat.ignore");
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private static final TypeFilter[] DEFAULT_ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    private static final TypeFilter CONVERTER_TYPE_FILTER = new AnnotationTypeFilter(Converter.class, false);
    private final PatternResourceLoader patternResourceLoader;
    @Nullable
    private TypeFilter[] entityTypeFilters = DEFAULT_ENTITY_TYPE_FILTERS;

    public LocalSessionFactoryBuilder(@Nullable DataSource dataSource) {
        this(dataSource, (ResourceLoader)new PathMatchingPatternResourceLoader());
    }

    public LocalSessionFactoryBuilder(@Nullable DataSource dataSource, ClassLoader classLoader) {
        this(dataSource, (ResourceLoader)new PathMatchingPatternResourceLoader(classLoader));
    }

    public LocalSessionFactoryBuilder(@Nullable DataSource dataSource, ResourceLoader resourceLoader) {
        this(dataSource, resourceLoader, new MetadataSources((ServiceRegistry)new BootstrapServiceRegistryBuilder().applyClassLoader(resourceLoader.getClassLoader()).build()));
    }

    public LocalSessionFactoryBuilder(@Nullable DataSource dataSource, ResourceLoader resourceLoader, MetadataSources metadataSources) {
        super(metadataSources);
        Properties properties = this.getProperties();
        properties.put("hibernate.current_session_context_class", HibernateSessionContext.class.getName());
        if (dataSource != null) {
            properties.put("hibernate.connection.datasource", dataSource);
        }
        properties.put("hibernate.connection.handling_mode", PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_HOLD);
        properties.put("hibernate.classLoaders", Collections.singleton(resourceLoader.getClassLoader()));
        this.patternResourceLoader = PatternResourceLoader.fromResourceLoader((ResourceLoader)resourceLoader);
    }

    public LocalSessionFactoryBuilder setJtaTransactionManager(Object jtaTransactionManager) {
        Assert.notNull((Object)jtaTransactionManager, (String)"Transaction manager reference is required");
        Properties properties = this.getProperties();
        if (jtaTransactionManager instanceof JtaTransactionManager) {
            boolean webspherePresent = ClassUtils.isPresent((String)"com.ibm.wsspi.uow.UOWManager", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            if (webspherePresent) {
                properties.put("hibernate.transaction.jta.platform", "org.hibernate.engine.transaction.jta.platform.internal.WebSphereExtendedJtaPlatform");
            } else {
                JtaTransactionManager jtaTm = (JtaTransactionManager)jtaTransactionManager;
                if (jtaTm.getTransactionManager() == null) {
                    throw new IllegalArgumentException("Can only apply JtaTransactionManager which has a TransactionManager reference set");
                }
                properties.put("hibernate.transaction.jta.platform", new ConfigurableJtaPlatform(jtaTm.getTransactionManager(), jtaTm.getUserTransaction(), jtaTm.getTransactionSynchronizationRegistry()));
            }
        } else if (jtaTransactionManager instanceof TransactionManager) {
            properties.put("hibernate.transaction.jta.platform", new ConfigurableJtaPlatform((TransactionManager)jtaTransactionManager, null, null));
        } else {
            throw new IllegalArgumentException("Unknown transaction manager type: " + jtaTransactionManager.getClass().getName());
        }
        properties.put("hibernate.transaction.coordinator_class", "jta");
        properties.put("hibernate.connection.handling_mode", PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_STATEMENT);
        return this;
    }

    public LocalSessionFactoryBuilder setBeanContainer(ConfigurableBeanFactory beanFactory) {
        this.getProperties().put("hibernate.resource.beans.container", new HibernateBeanContainer(beanFactory));
        return this;
    }

    public LocalSessionFactoryBuilder setCacheRegionFactory(RegionFactory cacheRegionFactory) {
        this.getProperties().put("hibernate.cache.region.factory_class", cacheRegionFactory);
        return this;
    }

    public LocalSessionFactoryBuilder setMultiTenantConnectionProvider(MultiTenantConnectionProvider multiTenantConnectionProvider) {
        this.getProperties().put("hibernate.multi_tenant_connection_provider", multiTenantConnectionProvider);
        return this;
    }

    public void setCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver currentTenantIdentifierResolver) {
        this.getProperties().put("hibernate.tenant_identifier_resolver", currentTenantIdentifierResolver);
        super.setCurrentTenantIdentifierResolver(currentTenantIdentifierResolver);
    }

    public LocalSessionFactoryBuilder setEntityTypeFilters(TypeFilter ... entityTypeFilters) {
        this.entityTypeFilters = entityTypeFilters;
        return this;
    }

    public LocalSessionFactoryBuilder addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
        return this;
    }

    public LocalSessionFactoryBuilder addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
        return this;
    }

    public LocalSessionFactoryBuilder scanPackages(String ... packagesToScan) throws HibernateException {
        TreeSet<String> packageNames = new TreeSet<String>();
        TreeSet<String> entityClassNames = new TreeSet<String>();
        TreeSet<String> converterClassNames = new TreeSet<String>();
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.patternResourceLoader);
                for (Resource resource : this.patternResourceLoader.getResources(pattern)) {
                    try {
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        if (this.matchesEntityTypeFilter(reader, (MetadataReaderFactory)readerFactory)) {
                            entityClassNames.add(className);
                            continue;
                        }
                        if (CONVERTER_TYPE_FILTER.match(reader, (MetadataReaderFactory)readerFactory)) {
                            converterClassNames.add(className);
                            continue;
                        }
                        if (!className.endsWith(PACKAGE_INFO_SUFFIX)) continue;
                        packageNames.add(className.substring(0, className.length() - PACKAGE_INFO_SUFFIX.length()));
                    }
                    catch (FileNotFoundException reader) {
                    }
                    catch (ClassFormatException ex) {
                        if (shouldIgnoreClassFormatException) continue;
                        throw new MappingException("Incompatible class format in " + resource, (Throwable)ex);
                    }
                    catch (Throwable ex) {
                        throw new MappingException("Failed to read candidate component class: " + resource, ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        try {
            ClassLoader cl = this.patternResourceLoader.getClassLoader();
            for (String className : entityClassNames) {
                this.addAnnotatedClass(ClassUtils.forName((String)className, (ClassLoader)cl));
            }
            for (String className : converterClassNames) {
                this.addAttributeConverter(ClassUtils.forName((String)className, (ClassLoader)cl));
            }
            for (String packageName : packageNames) {
                this.addPackage(packageName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
        return this;
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.entityTypeFilters != null) {
            for (TypeFilter filter : this.entityTypeFilters) {
                if (!filter.match(reader, readerFactory)) continue;
                return true;
            }
        }
        return false;
    }

    public SessionFactory buildSessionFactory(AsyncTaskExecutor bootstrapExecutor) {
        Assert.notNull((Object)bootstrapExecutor, (String)"AsyncTaskExecutor is required");
        return (SessionFactory)Proxy.newProxyInstance(this.patternResourceLoader.getClassLoader(), new Class[]{SessionFactoryImplementor.class, InfrastructureProxy.class}, (InvocationHandler)new BootstrapSessionFactoryInvocationHandler(bootstrapExecutor));
    }

    private class BootstrapSessionFactoryInvocationHandler
    implements InvocationHandler {
        private final Future<SessionFactory> sessionFactoryFuture;

        public BootstrapSessionFactoryInvocationHandler(AsyncTaskExecutor bootstrapExecutor) {
            this.sessionFactoryFuture = bootstrapExecutor.submit(() -> ((LocalSessionFactoryBuilder)LocalSessionFactoryBuilder.this).buildSessionFactory());
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "getProperties": {
                    return LocalSessionFactoryBuilder.this.getProperties();
                }
                case "getWrappedObject": {
                    return this.getSessionFactory();
                }
            }
            try {
                return method.invoke((Object)this.getSessionFactory(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private SessionFactory getSessionFactory() {
            try {
                return this.sessionFactoryFuture.get();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted during initialization of Hibernate SessionFactory", ex);
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof HibernateException) {
                    throw (HibernateException)cause;
                }
                throw new IllegalStateException("Failed to asynchronously initialize Hibernate SessionFactory: " + ex.getMessage(), cause);
            }
        }
    }
}

