/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.hibernate5;

import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.orm.hibernate5.HibernateFlushSynchronization;
import cn.taketoday.orm.hibernate5.HibernateJtaSessionContext;
import cn.taketoday.orm.hibernate5.HibernateSessionSynchronization;
import cn.taketoday.orm.hibernate5.SessionHolder;
import cn.taketoday.orm.jpa.EntityManagerHolder;
import cn.taketoday.transaction.support.SynchronizationInfo;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;

public class HibernateSessionContext
implements CurrentSessionContext {
    private final SessionFactoryImplementor sessionFactory;
    @Nullable
    private TransactionManager transactionManager;
    @Nullable
    private CurrentSessionContext jtaSessionContext;

    public HibernateSessionContext(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        try {
            JtaPlatform jtaPlatform = (JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class);
            this.transactionManager = jtaPlatform.retrieveTransactionManager();
            if (this.transactionManager != null) {
                this.jtaSessionContext = new HibernateJtaSessionContext(sessionFactory);
            }
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(HibernateSessionContext.class).warn("Could not introspect Hibernate JtaPlatform for FrameworkJtaSessionContext", (Throwable)ex);
        }
    }

    public Session currentSession() throws HibernateException {
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        Object value = info.getResource((Object)this.sessionFactory);
        if (value instanceof Session) {
            Session session = (Session)value;
            return session;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)((Object)value);
            Session session = sessionHolder.getSession();
            if (!sessionHolder.isSynchronizedWithTransaction() && info.isSynchronizationActive()) {
                info.registerSynchronization((TransactionSynchronization)new HibernateSessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory, false));
                sessionHolder.setSynchronizedWithTransaction(true);
                FlushMode flushMode = session.getHibernateFlushMode();
                if (flushMode.equals((Object)FlushMode.MANUAL) && !info.isCurrentTransactionReadOnly()) {
                    session.setHibernateFlushMode(FlushMode.AUTO);
                    sessionHolder.setPreviousFlushMode(flushMode);
                }
            }
            return session;
        }
        if (value instanceof EntityManagerHolder) {
            EntityManagerHolder entityManagerHolder = (EntityManagerHolder)((Object)value);
            return (Session)entityManagerHolder.getEntityManager().unwrap(Session.class);
        }
        if (this.transactionManager != null && this.jtaSessionContext != null) {
            try {
                if (this.transactionManager.getStatus() == 0) {
                    Session session = this.jtaSessionContext.currentSession();
                    if (info.isSynchronizationActive()) {
                        info.registerSynchronization((TransactionSynchronization)new HibernateFlushSynchronization(session));
                    }
                    return session;
                }
            }
            catch (SystemException ex) {
                throw new HibernateException("JTA TransactionManager found but status check failed", (Throwable)ex);
            }
        }
        if (info.isSynchronizationActive()) {
            Session session = this.sessionFactory.openSession();
            if (info.isCurrentTransactionReadOnly()) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
            }
            SessionHolder sessionHolder = new SessionHolder(session);
            info.registerSynchronization((TransactionSynchronization)new HibernateSessionSynchronization(sessionHolder, (SessionFactory)this.sessionFactory, true));
            info.bindResource((Object)this.sessionFactory, (Object)sessionHolder);
            sessionHolder.setSynchronizedWithTransaction(true);
            return session;
        }
        throw new HibernateException("Could not obtain transaction-synchronized Session for current thread");
    }
}

