/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.hibernate5;

import cn.taketoday.dao.DataAccessException;
import cn.taketoday.dao.support.PersistenceExceptionTranslator;
import cn.taketoday.jdbc.support.SQLExceptionTranslator;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.hibernate5.SessionFactoryUtils;
import cn.taketoday.orm.jpa.EntityManagerFactoryUtils;
import jakarta.persistence.PersistenceException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;

public class HibernateExceptionTranslator
implements PersistenceExceptionTranslator {
    @Nullable
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)((Object)ex));
        }
        if (ex instanceof PersistenceException) {
            if (ex.getCause() instanceof HibernateException) {
                return this.convertHibernateAccessException((HibernateException)ex.getCause());
            }
            return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
        }
        return null;
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        JDBCException jdbcEx;
        DataAccessException dae;
        if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException && (dae = this.jdbcExceptionTranslator.translate("Hibernate operation: " + (jdbcEx = (JDBCException)ex).getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException())) != null) {
            return dae;
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }
}

