/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.hibernate5;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanCreationException;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.type.spi.TypeBootstrapContext;

public final class HibernateBeanContainer
implements BeanContainer {
    private static final Logger log = LoggerFactory.getLogger(HibernateBeanContainer.class);
    private final ConfigurableBeanFactory beanFactory;
    private final Map<Object, HibernateContainedBean<?>> beanCache = new ConcurrentReferenceHashMap();

    public HibernateBeanContainer(ConfigurableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"ConfigurableBeanFactory is required");
        this.beanFactory = beanFactory;
    }

    public <B> ContainedBean<B> getBean(Class<B> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
        HibernateContainedBean<?> bean;
        if (lifecycleOptions.canUseCachedReferences()) {
            bean = this.beanCache.get(beanType);
            if (bean == null) {
                bean = this.createBean(beanType, lifecycleOptions, fallbackProducer);
                this.beanCache.put(beanType, bean);
            }
        } else {
            bean = this.createBean(beanType, lifecycleOptions, fallbackProducer);
        }
        return bean;
    }

    public <B> ContainedBean<B> getBean(String name, Class<B> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
        HibernateContainedBean<?> bean;
        if (lifecycleOptions.canUseCachedReferences()) {
            bean = this.beanCache.get(name);
            if (bean == null) {
                bean = this.createBean(name, beanType, lifecycleOptions, fallbackProducer);
                this.beanCache.put(name, bean);
            }
        } else {
            bean = this.createBean(name, beanType, lifecycleOptions, fallbackProducer);
        }
        return bean;
    }

    public void stop() {
        this.beanCache.values().forEach(HibernateContainedBean::destroyIfNecessary);
        this.beanCache.clear();
    }

    private HibernateContainedBean<?> createBean(Class<?> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
        try {
            if (lifecycleOptions.useJpaCompliantCreation()) {
                return new HibernateContainedBean<Object>(this.beanFactory.createBean(beanType), arg_0 -> ((ConfigurableBeanFactory)this.beanFactory).destroyBean(arg_0));
            }
            return new HibernateContainedBean<Object>(this.beanFactory.getBean(beanType));
        }
        catch (BeansException ex) {
            log.debug("Falling back to Hibernate's default producer after bean creation failure for {}: {}", beanType, (Object)ex.toString());
            try {
                return new HibernateContainedBean<Object>(fallbackProducer.produceBeanInstance(beanType));
            }
            catch (RuntimeException ex2) {
                if (ex instanceof BeanCreationException) {
                    log.debug("Fallback producer failed for {}: {}", beanType, (Object)ex2.toString());
                    throw ex;
                }
                throw ex2;
            }
        }
    }

    private HibernateContainedBean<?> createBean(String name, Class<?> beanType, BeanContainer.LifecycleOptions lifecycleOptions, BeanInstanceProducer fallbackProducer) {
        try {
            if (lifecycleOptions.useJpaCompliantCreation()) {
                Object bean = null;
                if (fallbackProducer instanceof TypeBootstrapContext) {
                    bean = fallbackProducer.produceBeanInstance(name, beanType);
                }
                if (this.beanFactory.containsBean(name)) {
                    if (bean == null) {
                        bean = this.beanFactory.autowire(beanType, 3, false);
                    }
                    this.beanFactory.autowireBeanProperties(bean, 0, false);
                    this.beanFactory.applyBeanPropertyValues(bean, name);
                    bean = this.beanFactory.initializeBean(bean, name);
                    return new HibernateContainedBean<Object>(bean, beanInstance -> this.beanFactory.destroyBean(name, beanInstance));
                }
                if (bean != null) {
                    this.beanFactory.autowireBeanProperties(bean, 0, false);
                    bean = this.beanFactory.initializeBean(bean, name);
                    return new HibernateContainedBean<Object>(bean, arg_0 -> ((ConfigurableBeanFactory)this.beanFactory).destroyBean(arg_0));
                }
                return new HibernateContainedBean<Object>(this.beanFactory.createBean(beanType), arg_0 -> ((ConfigurableBeanFactory)this.beanFactory).destroyBean(arg_0));
            }
            return this.beanFactory.containsBean(name) ? new HibernateContainedBean<Object>(this.beanFactory.getBean(name, beanType)) : new HibernateContainedBean<Object>(this.beanFactory.getBean(beanType));
        }
        catch (BeansException ex) {
            log.debug("Falling back to Hibernate's default producer after bean creation failure for {} with name '{}': {}", new Object[]{name, beanType, ex.toString()});
            try {
                return new HibernateContainedBean<Object>(fallbackProducer.produceBeanInstance(name, beanType));
            }
            catch (RuntimeException ex2) {
                if (ex instanceof BeanCreationException) {
                    log.debug("Fallback producer failed for {} with name '{}}': {}", new Object[]{beanType, name, ex2.toString()});
                    throw ex;
                }
                throw ex2;
            }
        }
    }

    private static final class HibernateContainedBean<B>
    implements ContainedBean<B> {
        private final B beanInstance;
        @Nullable
        private Consumer<B> destructionCallback;

        public HibernateContainedBean(B beanInstance) {
            this.beanInstance = beanInstance;
        }

        public HibernateContainedBean(B beanInstance, Consumer<B> destructionCallback) {
            this.beanInstance = beanInstance;
            this.destructionCallback = destructionCallback;
        }

        public B getBeanInstance() {
            return this.beanInstance;
        }

        public void destroyIfNecessary() {
            if (this.destructionCallback != null) {
                this.destructionCallback.accept(this.beanInstance);
            }
        }
    }
}

