/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.vendor;

import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.vendor.AbstractJpaVendorAdapter;
import cn.taketoday.orm.jpa.vendor.Database;
import cn.taketoday.orm.jpa.vendor.HibernateJpaDialect;
import cn.taketoday.orm.jpa.vendor.HibernateJpaPersistenceProvider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyTenSevenDialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HANAColumnStoreDialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.Informix10Dialect;
import org.hibernate.dialect.MySQL57Dialect;
import org.hibernate.dialect.Oracle12cDialect;
import org.hibernate.dialect.PostgreSQL95Dialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;

public class HibernateJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final HibernateJpaDialect jpaDialect = new HibernateJpaDialect();
    private final PersistenceProvider persistenceProvider = new HibernateJpaPersistenceProvider();
    private final Class<? extends EntityManagerFactory> entityManagerFactoryInterface = SessionFactory.class;
    private final Class<? extends EntityManager> entityManagerInterface = Session.class;

    public void setPrepareConnection(boolean prepareConnection) {
        this.jpaDialect.setPrepareConnection(prepareConnection);
    }

    @Override
    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    @Override
    public String getPersistenceProviderRootPackage() {
        return "org.hibernate";
    }

    public Map<String, Object> getJpaPropertyMap(PersistenceUnitInfo pui) {
        return this.buildJpaPropertyMap(this.jpaDialect.prepareConnection && pui.getTransactionType() != PersistenceUnitTransactionType.JTA);
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.buildJpaPropertyMap(this.jpaDialect.prepareConnection);
    }

    private Map<String, Object> buildJpaPropertyMap(boolean connectionReleaseOnClose) {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("hibernate.dialect", this.getDatabasePlatform());
        } else {
            Class<?> databaseDialectClass = this.determineDatabaseDialectClass(this.getDatabase());
            if (databaseDialectClass != null) {
                jpaProperties.put("hibernate.dialect", databaseDialectClass.getName());
            }
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("hibernate.hbm2ddl.auto", "update");
        }
        if (this.isShowSql()) {
            jpaProperties.put("hibernate.show_sql", "true");
        }
        if (connectionReleaseOnClose) {
            jpaProperties.put("hibernate.connection.handling_mode", PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_HOLD);
        }
        return jpaProperties;
    }

    @Nullable
    protected Class<?> determineDatabaseDialectClass(Database database) {
        return switch (database) {
            case Database.DB2 -> DB2Dialect.class;
            case Database.DERBY -> DerbyTenSevenDialect.class;
            case Database.H2 -> H2Dialect.class;
            case Database.HANA -> HANAColumnStoreDialect.class;
            case Database.HSQL -> HSQLDialect.class;
            case Database.INFORMIX -> Informix10Dialect.class;
            case Database.MYSQL -> MySQL57Dialect.class;
            case Database.ORACLE -> Oracle12cDialect.class;
            case Database.POSTGRESQL -> PostgreSQL95Dialect.class;
            case Database.SQL_SERVER -> SQLServer2012Dialect.class;
            case Database.SYBASE -> SybaseDialect.class;
            default -> null;
        };
    }

    @Override
    public HibernateJpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    @Override
    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return this.entityManagerFactoryInterface;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return this.entityManagerInterface;
    }
}

