/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.support;

import cn.taketoday.core.task.AsyncTaskExecutor;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.JpaVendorAdapter;
import cn.taketoday.orm.jpa.LocalContainerEntityManagerFactoryBean;
import cn.taketoday.orm.jpa.persistenceunit.PersistenceManagedTypes;
import cn.taketoday.orm.jpa.persistenceunit.PersistenceUnitManager;
import cn.taketoday.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public class EntityManagerFactoryBuilder {
    private final JpaVendorAdapter jpaVendorAdapter;
    @Nullable
    private final PersistenceUnitManager persistenceUnitManager;
    private final Map<String, Object> jpaProperties;
    @Nullable
    private final URL persistenceUnitRootLocation;
    @Nullable
    private AsyncTaskExecutor bootstrapExecutor;
    @Nullable
    private PersistenceUnitPostProcessor[] persistenceUnitPostProcessors;

    public EntityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, Map<String, ?> jpaProperties, @Nullable PersistenceUnitManager persistenceUnitManager) {
        this(jpaVendorAdapter, jpaProperties, persistenceUnitManager, null);
    }

    public EntityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, Map<String, ?> jpaProperties, @Nullable PersistenceUnitManager persistenceUnitManager, @Nullable URL persistenceUnitRootLocation) {
        this.jpaVendorAdapter = jpaVendorAdapter;
        this.persistenceUnitManager = persistenceUnitManager;
        this.jpaProperties = new LinkedHashMap(jpaProperties);
        this.persistenceUnitRootLocation = persistenceUnitRootLocation;
    }

    public Builder dataSource(DataSource dataSource) {
        return new Builder(dataSource);
    }

    public void setBootstrapExecutor(AsyncTaskExecutor bootstrapExecutor) {
        this.bootstrapExecutor = bootstrapExecutor;
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... persistenceUnitPostProcessors) {
        this.persistenceUnitPostProcessors = persistenceUnitPostProcessors;
    }

    public final class Builder {
        private DataSource dataSource;
        @Nullable
        private PersistenceManagedTypes managedTypes;
        private String[] packagesToScan;
        @Nullable
        private String persistenceUnit;
        private Map<String, Object> properties = new HashMap<String, Object>();
        @Nullable
        private String[] mappingResources;
        private boolean jta;

        private Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Builder managedTypes(PersistenceManagedTypes managedTypes) {
            this.managedTypes = managedTypes;
            return this;
        }

        public Builder packages(String ... packagesToScan) {
            this.packagesToScan = packagesToScan;
            return this;
        }

        public Builder packages(Class<?> ... basePackageClasses) {
            HashSet<String> packages = new HashSet<String>();
            for (Class<?> type : basePackageClasses) {
                packages.add(ClassUtils.getPackageName(type));
            }
            this.packagesToScan = StringUtils.toStringArray(packages);
            return this;
        }

        public Builder persistenceUnit(String persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
            return this;
        }

        public Builder properties(Map<String, ?> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder mappingResources(String ... mappingResources) {
            this.mappingResources = mappingResources;
            return this;
        }

        public Builder jta(boolean jta) {
            this.jta = jta;
            return this;
        }

        public LocalContainerEntityManagerFactoryBean build() {
            URL rootLocation;
            LocalContainerEntityManagerFactoryBean factoryBean = new LocalContainerEntityManagerFactoryBean();
            if (EntityManagerFactoryBuilder.this.persistenceUnitManager != null) {
                factoryBean.setPersistenceUnitManager(EntityManagerFactoryBuilder.this.persistenceUnitManager);
            }
            if (this.persistenceUnit != null) {
                factoryBean.setPersistenceUnitName(this.persistenceUnit);
            }
            factoryBean.setJpaVendorAdapter(EntityManagerFactoryBuilder.this.jpaVendorAdapter);
            if (this.jta) {
                factoryBean.setJtaDataSource(this.dataSource);
            } else {
                factoryBean.setDataSource(this.dataSource);
            }
            if (this.managedTypes != null) {
                factoryBean.setManagedTypes(this.managedTypes);
            } else {
                factoryBean.setPackagesToScan(this.packagesToScan);
            }
            factoryBean.getJpaPropertyMap().putAll(EntityManagerFactoryBuilder.this.jpaProperties);
            factoryBean.getJpaPropertyMap().putAll(this.properties);
            if (ObjectUtils.isNotEmpty((Object[])this.mappingResources)) {
                factoryBean.setMappingResources(this.mappingResources);
            }
            if ((rootLocation = EntityManagerFactoryBuilder.this.persistenceUnitRootLocation) != null) {
                factoryBean.setPersistenceUnitRootLocation(rootLocation.toString());
            }
            if (EntityManagerFactoryBuilder.this.bootstrapExecutor != null) {
                factoryBean.setBootstrapExecutor(EntityManagerFactoryBuilder.this.bootstrapExecutor);
            }
            if (EntityManagerFactoryBuilder.this.persistenceUnitPostProcessors != null) {
                factoryBean.setPersistenceUnitPostProcessors(EntityManagerFactoryBuilder.this.persistenceUnitPostProcessors);
            }
            return factoryBean;
        }
    }
}

