/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.persistenceunit;

import cn.taketoday.context.index.CandidateComponentsIndex;
import cn.taketoday.context.index.CandidateComponentsIndexLoader;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.classreading.CachingMetadataReaderFactory;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.filter.AnnotationTypeFilter;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.persistenceunit.PersistenceManagedTypes;
import cn.taketoday.orm.jpa.persistenceunit.SimplePersistenceManagedTypes;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ResourceUtils;
import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PersistenceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PersistenceManagedTypesScanner {
    private static final String CLASS_RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private final List<AnnotationTypeFilter> entityTypeFilters = List.of(new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false), new AnnotationTypeFilter(Converter.class, false));
    private final PatternResourceLoader patternResourceLoader;
    @Nullable
    private final CandidateComponentsIndex componentsIndex;

    public PersistenceManagedTypesScanner(ResourceLoader resourceLoader) {
        this.patternResourceLoader = PatternResourceLoader.fromResourceLoader((ResourceLoader)resourceLoader);
        this.componentsIndex = CandidateComponentsIndexLoader.loadIndex((ClassLoader)resourceLoader.getClassLoader());
    }

    public PersistenceManagedTypes scan(String ... packagesToScan) {
        ScanResult scanResult = new ScanResult();
        for (String pkg : packagesToScan) {
            this.scanPackage(pkg, scanResult);
        }
        return scanResult.toJpaManagedTypes();
    }

    private void scanPackage(String pkg, ScanResult scanResult) {
        if (this.componentsIndex != null) {
            HashSet candidates = new HashSet();
            for (AnnotationTypeFilter filter : this.entityTypeFilters) {
                candidates.addAll(this.componentsIndex.getCandidateTypes(pkg, filter.getAnnotationType().getName()));
            }
            scanResult.managedClassNames.addAll(candidates);
            scanResult.managedPackages.addAll(this.componentsIndex.getCandidateTypes(pkg, "package-info"));
            return;
        }
        try {
            String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + CLASS_RESOURCE_PATTERN;
            Set resources = this.patternResourceLoader.getResources(pattern);
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.patternResourceLoader);
            for (Resource resource : resources) {
                try {
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) {
                        URL url;
                        scanResult.managedClassNames.add(className);
                        if (scanResult.persistenceUnitRootUrl != null || !ResourceUtils.isJarURL((URL)(url = resource.getURL()))) continue;
                        scanResult.persistenceUnitRootUrl = ResourceUtils.extractJarFileURL((URL)url);
                        continue;
                    }
                    if (!className.endsWith(PACKAGE_INFO_SUFFIX)) continue;
                    scanResult.managedPackages.add(className.substring(0, className.length() - PACKAGE_INFO_SUFFIX.length()));
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        catch (IOException ex) {
            throw new PersistenceException("Failed to scan classpath for unlisted entity classes", (Throwable)ex);
        }
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter typeFilter : this.entityTypeFilters) {
            if (!typeFilter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    private static class ScanResult {
        public final ArrayList<String> managedClassNames = new ArrayList();
        public final ArrayList<String> managedPackages = new ArrayList();
        @Nullable
        public URL persistenceUnitRootUrl;

        private ScanResult() {
        }

        PersistenceManagedTypes toJpaManagedTypes() {
            return new SimplePersistenceManagedTypes(this.managedClassNames, this.managedPackages, this.persistenceUnitRootUrl);
        }
    }
}

