/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.persistenceunit;

import cn.taketoday.core.DecoratingClassLoader;
import cn.taketoday.instrument.LoadTimeWeaver;
import cn.taketoday.instrument.SimpleThrowawayClassLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.orm.jpa.persistenceunit.ClassFileTransformerAdapter;
import cn.taketoday.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import jakarta.persistence.spi.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;

class JpaPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    @Nullable
    private LoadTimeWeaver loadTimeWeaver;
    @Nullable
    private ClassLoader classLoader;

    JpaPersistenceUnitInfo() {
    }

    public void init(LoadTimeWeaver loadTimeWeaver) {
        Assert.notNull((Object)loadTimeWeaver, (String)"LoadTimeWeaver must not be null");
        this.loadTimeWeaver = loadTimeWeaver;
        this.classLoader = loadTimeWeaver.getInstrumentableClassLoader();
    }

    public void init(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver != null) {
            this.loadTimeWeaver.addTransformer((ClassFileTransformer)new ClassFileTransformerAdapter(classTransformer));
        } else {
            LoggerFactory.getLogger(this.getClass()).info("No LoadTimeWeaver setup: ignoring JPA class transformer");
        }
    }

    @Override
    public ClassLoader getNewTempClassLoader() {
        Object tcl = this.loadTimeWeaver != null ? this.loadTimeWeaver.getThrowawayClassLoader() : new SimpleThrowawayClassLoader(this.classLoader);
        String packageToExclude = this.getPersistenceProviderPackageName();
        if (packageToExclude != null && tcl instanceof DecoratingClassLoader) {
            ((DecoratingClassLoader)tcl).excludePackage(packageToExclude);
        }
        return tcl;
    }
}

