/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa;

import cn.taketoday.orm.jpa.AbstractEntityManagerFactoryBean;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;

public class LocalEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean {
    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        PersistenceProvider provider;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Building JPA EntityManagerFactory for persistence unit '{}'", (Object)this.getPersistenceUnitName());
        }
        if ((provider = this.getPersistenceProvider()) != null) {
            EntityManagerFactory emf = provider.createEntityManagerFactory(this.getPersistenceUnitName(), this.getJpaPropertyMap());
            if (emf == null) {
                throw new IllegalStateException("PersistenceProvider [" + provider + "] did not return an EntityManagerFactory for name '" + this.getPersistenceUnitName() + "'");
            }
            return emf;
        }
        return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), this.getJpaPropertyMap());
    }
}

