/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.transaction.SavepointManager;
import cn.taketoday.transaction.support.ResourceHolderSupport;
import jakarta.persistence.EntityManager;

public class EntityManagerHolder
extends ResourceHolderSupport {
    @Nullable
    private final EntityManager entityManager;
    private boolean transactionActive;
    @Nullable
    private SavepointManager savepointManager;

    public EntityManagerHolder(@Nullable EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        Assert.state((this.entityManager != null ? 1 : 0) != 0, (String)"No EntityManager available");
        return this.entityManager;
    }

    protected void setTransactionActive(boolean transactionActive) {
        this.transactionActive = transactionActive;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void setSavepointManager(@Nullable SavepointManager savepointManager) {
        this.savepointManager = savepointManager;
    }

    @Nullable
    protected SavepointManager getSavepointManager() {
        return this.savepointManager;
    }

    public void clear() {
        super.clear();
        this.transactionActive = false;
        this.savepointManager = null;
    }
}

