/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryUtils;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.core.Ordered;
import cn.taketoday.dao.CannotAcquireLockException;
import cn.taketoday.dao.DataAccessException;
import cn.taketoday.dao.DataAccessResourceFailureException;
import cn.taketoday.dao.DataIntegrityViolationException;
import cn.taketoday.dao.EmptyResultDataAccessException;
import cn.taketoday.dao.IncorrectResultSizeDataAccessException;
import cn.taketoday.dao.InvalidDataAccessApiUsageException;
import cn.taketoday.dao.PessimisticLockingFailureException;
import cn.taketoday.dao.QueryTimeoutException;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.orm.jpa.EntityManagerFactoryInfo;
import cn.taketoday.orm.jpa.EntityManagerHolder;
import cn.taketoday.orm.jpa.EntityManagerProxy;
import cn.taketoday.orm.jpa.JpaDialect;
import cn.taketoday.orm.jpa.JpaObjectRetrievalFailureException;
import cn.taketoday.orm.jpa.JpaOptimisticLockingFailureException;
import cn.taketoday.orm.jpa.JpaSystemException;
import cn.taketoday.transaction.support.ResourceHolder;
import cn.taketoday.transaction.support.ResourceHolderSynchronization;
import cn.taketoday.transaction.support.SynchronizationInfo;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TransactionRequiredException;
import java.util.Map;
import java.util.Set;

public abstract class EntityManagerFactoryUtils {
    public static final int ENTITY_MANAGER_SYNCHRONIZATION_ORDER = 900;
    private static final Logger logger = LoggerFactory.getLogger(EntityManagerFactoryUtils.class);

    public static EntityManagerFactory findEntityManagerFactory(BeanFactory beanFactory, @Nullable String unitName) throws NoSuchBeanDefinitionException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (StringUtils.isNotEmpty((CharSequence)unitName)) {
            Set candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)beanFactory, EntityManagerFactory.class);
            for (String candidateName : candidateNames) {
                EntityManagerFactoryInfo info;
                EntityManagerFactory emf = (EntityManagerFactory)beanFactory.getBean(candidateName);
                if (!(emf instanceof EntityManagerFactoryInfo) || !unitName.equals((info = (EntityManagerFactoryInfo)emf).getPersistenceUnitName())) continue;
                return emf;
            }
            return (EntityManagerFactory)beanFactory.getBean(unitName, EntityManagerFactory.class);
        }
        return (EntityManagerFactory)beanFactory.getBean(EntityManagerFactory.class);
    }

    @Nullable
    public static EntityManager getTransactionalEntityManager(EntityManagerFactory emf) throws DataAccessResourceFailureException {
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, null);
    }

    @Nullable
    public static EntityManager getTransactionalEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties) throws DataAccessResourceFailureException {
        try {
            return EntityManagerFactoryUtils.doGetTransactionalEntityManager(emf, properties, true);
        }
        catch (PersistenceException ex) {
            throw new DataAccessResourceFailureException("Could not obtain JPA EntityManager", (Throwable)ex);
        }
    }

    @Nullable
    public static EntityManager doGetTransactionalEntityManager(EntityManagerFactory emf, Map<?, ?> properties) throws PersistenceException {
        return EntityManagerFactoryUtils.doGetTransactionalEntityManager(emf, properties, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static EntityManager doGetTransactionalEntityManager(EntityManagerFactory emf, @Nullable Map<?, ?> properties, boolean synchronizedWithTransaction) throws PersistenceException {
        Assert.notNull((Object)emf, (String)"No EntityManagerFactory specified");
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        EntityManagerHolder emHolder = (EntityManagerHolder)((Object)info.getResource((Object)emf));
        if (emHolder != null) {
            if (synchronizedWithTransaction) {
                if (!emHolder.isSynchronizedWithTransaction()) {
                    if (info.isActualTransactionActive()) {
                        try {
                            emHolder.getEntityManager().joinTransaction();
                        }
                        catch (TransactionRequiredException ex) {
                            logger.debug("Could not join transaction because none was actually active", (Throwable)ex);
                        }
                    }
                    if (info.isSynchronizationActive()) {
                        Object transactionData = EntityManagerFactoryUtils.prepareTransaction(emHolder.getEntityManager(), emf);
                        info.registerSynchronization((TransactionSynchronization)new TransactionalEntityManagerSynchronization(emHolder, emf, transactionData, false));
                        emHolder.setSynchronizedWithTransaction(true);
                    }
                }
                emHolder.requested();
                return emHolder.getEntityManager();
            }
            if (!emHolder.isTransactionActive() || emHolder.isOpen()) return emHolder.getEntityManager();
            if (!info.isSynchronizationActive()) {
                return null;
            }
            info.unbindResource((Object)emf);
        } else if (!info.isSynchronizationActive()) {
            return null;
        }
        logger.debug("Opening JPA EntityManager");
        EntityManager em = null;
        if (!synchronizedWithTransaction) {
            try {
                em = emf.createEntityManager(SynchronizationType.UNSYNCHRONIZED, properties);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        if (em == null) {
            em = CollectionUtils.isNotEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        }
        try {
            emHolder = new EntityManagerHolder(em);
            if (synchronizedWithTransaction) {
                Object transactionData = EntityManagerFactoryUtils.prepareTransaction(em, emf);
                info.registerSynchronization((TransactionSynchronization)new TransactionalEntityManagerSynchronization(emHolder, emf, transactionData, true));
                emHolder.setSynchronizedWithTransaction(true);
            } else {
                info.registerSynchronization((TransactionSynchronization)new TransactionScopedEntityManagerSynchronization(emHolder, emf));
            }
            info.bindResource((Object)emf, (Object)emHolder);
            return em;
        }
        catch (RuntimeException ex) {
            EntityManagerFactoryUtils.closeEntityManager(em);
            throw ex;
        }
    }

    @Nullable
    private static Object prepareTransaction(EntityManager em, EntityManagerFactory emf) {
        EntityManagerFactoryInfo emfInfo;
        JpaDialect jpaDialect;
        if (emf instanceof EntityManagerFactoryInfo && (jpaDialect = (emfInfo = (EntityManagerFactoryInfo)emf).getJpaDialect()) != null) {
            return jpaDialect.prepareTransaction(em, TransactionSynchronizationManager.isCurrentTransactionReadOnly(), TransactionSynchronizationManager.getCurrentTransactionName());
        }
        return null;
    }

    private static void cleanupTransaction(@Nullable Object transactionData, EntityManagerFactory emf) {
        EntityManagerFactoryInfo emfInfo;
        JpaDialect jpaDialect;
        if (emf instanceof EntityManagerFactoryInfo && (jpaDialect = (emfInfo = (EntityManagerFactoryInfo)emf).getJpaDialect()) != null) {
            jpaDialect.cleanupTransaction(transactionData);
        }
    }

    public static void applyTransactionTimeout(Query query, EntityManagerFactory emf) {
        EntityManagerHolder emHolder = (EntityManagerHolder)((Object)TransactionSynchronizationManager.getResource((Object)emf));
        if (emHolder != null && emHolder.hasTimeout()) {
            int timeoutValue = (int)emHolder.getTimeToLiveInMillis();
            try {
                query.setHint("jakarta.persistence.query.timeout", (Object)timeoutValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public static DataAccessException convertJpaAccessExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof IllegalStateException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof IllegalArgumentException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof EntityNotFoundException) {
            return new JpaObjectRetrievalFailureException((EntityNotFoundException)ex);
        }
        if (ex instanceof NoResultException) {
            return new EmptyResultDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof jakarta.persistence.QueryTimeoutException) {
            return new QueryTimeoutException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof LockTimeoutException) {
            return new CannotAcquireLockException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PessimisticLockException) {
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof OptimisticLockException) {
            return new JpaOptimisticLockingFailureException((OptimisticLockException)ex);
        }
        if (ex instanceof EntityExistsException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransactionRequiredException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistenceException) {
            return new JpaSystemException(ex);
        }
        return null;
    }

    public static void closeEntityManager(@Nullable EntityManager em) {
        if (em != null) {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (Throwable ex) {
                logger.error("Failed to release JPA EntityManager", ex);
            }
        }
    }

    private static class TransactionalEntityManagerSynchronization
    extends ResourceHolderSynchronization<EntityManagerHolder, EntityManagerFactory>
    implements Ordered {
        @Nullable
        private final Object transactionData;
        @Nullable
        private final JpaDialect jpaDialect;
        private final boolean newEntityManager;

        public TransactionalEntityManagerSynchronization(EntityManagerHolder emHolder, EntityManagerFactory emf, @Nullable Object txData, boolean newEm) {
            super((ResourceHolder)emHolder, (Object)emf);
            JpaDialect jpaDialect;
            this.transactionData = txData;
            if (emf instanceof EntityManagerFactoryInfo) {
                EntityManagerFactoryInfo info = (EntityManagerFactoryInfo)emf;
                jpaDialect = info.getJpaDialect();
            } else {
                jpaDialect = null;
            }
            this.jpaDialect = jpaDialect;
            this.newEntityManager = newEm;
        }

        public int getOrder() {
            return 900;
        }

        protected void flushResource(EntityManagerHolder resourceHolder) {
            EntityManagerProxy proxy;
            EntityManager target;
            EntityManager em = resourceHolder.getEntityManager();
            if (em instanceof EntityManagerProxy && TransactionSynchronizationManager.hasResource((Object)(target = (proxy = (EntityManagerProxy)em).getTargetEntityManager()))) {
                return;
            }
            try {
                em.flush();
            }
            catch (RuntimeException ex) {
                DataAccessException dae = this.jpaDialect != null ? this.jpaDialect.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
                throw dae != null ? dae : ex;
            }
        }

        protected boolean shouldUnbindAtCompletion() {
            return this.newEntityManager;
        }

        protected void releaseResource(EntityManagerHolder resourceHolder, EntityManagerFactory resourceKey) {
            EntityManagerFactoryUtils.closeEntityManager(resourceHolder.getEntityManager());
        }

        protected void cleanupResource(EntityManagerHolder resourceHolder, EntityManagerFactory resourceKey, boolean committed) {
            if (!committed) {
                resourceHolder.getEntityManager().clear();
            }
            EntityManagerFactoryUtils.cleanupTransaction(this.transactionData, resourceKey);
        }
    }

    private static class TransactionScopedEntityManagerSynchronization
    extends ResourceHolderSynchronization<EntityManagerHolder, EntityManagerFactory>
    implements Ordered {
        public TransactionScopedEntityManagerSynchronization(EntityManagerHolder emHolder, EntityManagerFactory emf) {
            super((ResourceHolder)emHolder, (Object)emf);
        }

        public int getOrder() {
            return 901;
        }

        protected void releaseResource(EntityManagerHolder resourceHolder, EntityManagerFactory resourceKey) {
            EntityManagerFactoryUtils.closeEntityManager(resourceHolder.getEntityManager());
        }
    }
}

