/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.vendor;

import cn.taketoday.dao.CannotAcquireLockException;
import cn.taketoday.dao.DataAccessException;
import cn.taketoday.dao.DataAccessResourceFailureException;
import cn.taketoday.dao.DataIntegrityViolationException;
import cn.taketoday.dao.DuplicateKeyException;
import cn.taketoday.dao.IncorrectResultSizeDataAccessException;
import cn.taketoday.dao.InvalidDataAccessApiUsageException;
import cn.taketoday.dao.InvalidDataAccessResourceUsageException;
import cn.taketoday.dao.PessimisticLockingFailureException;
import cn.taketoday.jdbc.datasource.ConnectionHandle;
import cn.taketoday.jdbc.datasource.DataSourceUtils;
import cn.taketoday.jdbc.support.SQLExceptionTranslator;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.ObjectOptimisticLockingFailureException;
import cn.taketoday.orm.ObjectRetrievalFailureException;
import cn.taketoday.orm.jpa.DefaultJpaDialect;
import cn.taketoday.orm.jpa.EntityManagerFactoryUtils;
import cn.taketoday.orm.jpa.JpaSystemException;
import cn.taketoday.transaction.InvalidIsolationLevelException;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import cn.taketoday.transaction.support.ResourceTransactionDefinition;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.PropertyValueException;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    boolean prepareConnection = true;
    @Nullable
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    @Override
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        ResourceTransactionDefinition rtd;
        SessionImplementor session = this.getSession(entityManager);
        if (definition.getTimeout() != -1) {
            session.getTransaction().setTimeout(definition.getTimeout());
        }
        boolean isolationLevelNeeded = definition.getIsolationLevel() != -1;
        Integer previousIsolationLevel = null;
        Connection preparedCon = null;
        if (isolationLevelNeeded || definition.isReadOnly()) {
            LogicalConnectionImplementor logicalConnection;
            if (this.prepareConnection && ConnectionReleaseMode.ON_CLOSE.equals((Object)(logicalConnection = session.getJdbcCoordinator().getLogicalConnection()).getConnectionHandlingMode().getReleaseMode())) {
                preparedCon = logicalConnection.getPhysicalConnection();
                previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)preparedCon, (TransactionDefinition)definition);
            } else if (isolationLevelNeeded) {
                throw new InvalidIsolationLevelException("HibernateJpaDialect is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to ON_CLOSE.");
            }
        }
        entityManager.getTransaction().begin();
        FlushMode previousFlushMode = this.prepareFlushMode((Session)session, definition.isReadOnly());
        if (definition instanceof ResourceTransactionDefinition && (rtd = (ResourceTransactionDefinition)definition).isLocalResource()) {
            previousFlushMode = null;
            if (definition.isReadOnly()) {
                session.setDefaultReadOnly(true);
            }
        }
        return new SessionTransactionData(session, previousFlushMode, preparedCon != null, previousIsolationLevel, definition.isReadOnly());
    }

    @Override
    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, @Nullable String name) throws PersistenceException {
        SessionImplementor session = this.getSession(entityManager);
        FlushMode previousFlushMode = this.prepareFlushMode((Session)session, readOnly);
        return new SessionTransactionData(session, previousFlushMode, false, null, readOnly);
    }

    @Nullable
    protected FlushMode prepareFlushMode(Session session, boolean readOnly) throws PersistenceException {
        FlushMode flushMode = session.getHibernateFlushMode();
        if (readOnly) {
            if (!flushMode.equals((Object)FlushMode.MANUAL)) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
                return flushMode;
            }
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setHibernateFlushMode(FlushMode.AUTO);
            return flushMode;
        }
        return null;
    }

    @Override
    public void cleanupTransaction(@Nullable Object transactionData) {
        if (transactionData instanceof SessionTransactionData) {
            ((SessionTransactionData)transactionData).resetSessionState();
        }
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        SessionImplementor session = this.getSession(entityManager);
        return new HibernateConnectionHandle(session);
    }

    @Override
    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex);
        }
        if (ex instanceof PersistenceException && ex.getCause() instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex.getCause());
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        UnresolvableObjectException hibEx;
        JDBCException jdbcEx;
        DataAccessException dae;
        if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException && (dae = this.jdbcExceptionTranslator.translate("Hibernate operation: " + (jdbcEx = (JDBCException)ex).getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException())) != null) {
            throw dae;
        }
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SQLGrammarException) {
            jdbcEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof QueryTimeoutException) {
            jdbcEx = (QueryTimeoutException)ex;
            return new cn.taketoday.dao.QueryTimeoutException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof LockAcquisitionException) {
            jdbcEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof PessimisticLockException) {
            jdbcEx = (PessimisticLockException)ex;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof ConstraintViolationException) {
            jdbcEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]; constraint [" + jdbcEx.getConstraintName() + "]", (Throwable)ex);
        }
        if (ex instanceof DataException) {
            jdbcEx = (DataException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof QueryException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            hibEx = (UnresolvableObjectException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof WrongClassException) {
            hibEx = (WrongClassException)ex;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            hibEx = (StaleObjectStateException)ex;
            return new ObjectOptimisticLockingFailureException(hibEx.getEntityName(), (Object)hibEx.getIdentifier(), (Throwable)ex);
        }
        if (ex instanceof StaleStateException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof OptimisticEntityLockException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PessimisticEntityLockException) {
            if (ex.getCause() instanceof LockAcquisitionException) {
                return new CannotAcquireLockException(ex.getMessage(), ex.getCause());
            }
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        return new JpaSystemException((RuntimeException)ex);
    }

    protected SessionImplementor getSession(EntityManager entityManager) {
        return (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
    }

    private static class SessionTransactionData {
        private final SessionImplementor session;
        @Nullable
        private final FlushMode previousFlushMode;
        private final boolean needsConnectionReset;
        @Nullable
        private final Integer previousIsolationLevel;
        private final boolean readOnly;

        public SessionTransactionData(SessionImplementor session, @Nullable FlushMode previousFlushMode, boolean connectionPrepared, @Nullable Integer previousIsolationLevel, boolean readOnly) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
            this.needsConnectionReset = connectionPrepared;
            this.previousIsolationLevel = previousIsolationLevel;
            this.readOnly = readOnly;
        }

        public void resetSessionState() {
            LogicalConnectionImplementor logicalConnection;
            if (this.previousFlushMode != null) {
                this.session.setHibernateFlushMode(this.previousFlushMode);
            }
            if (this.needsConnectionReset && (logicalConnection = this.session.getJdbcCoordinator().getLogicalConnection()).isPhysicallyConnected()) {
                Connection con = logicalConnection.getPhysicalConnection();
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)this.previousIsolationLevel, (boolean)this.readOnly);
            }
        }
    }

    private record HibernateConnectionHandle(SessionImplementor session) implements ConnectionHandle
    {
        public Connection getConnection() {
            return this.session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
        }
    }
}

