/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa.vendor;

import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.vendor.AbstractJpaVendorAdapter;
import cn.taketoday.orm.jpa.vendor.Database;
import cn.taketoday.orm.jpa.vendor.EclipseLinkJpaDialect;
import jakarta.persistence.EntityManager;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.PersistenceProvider;

public class EclipseLinkJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final jakarta.persistence.spi.PersistenceProvider persistenceProvider = new PersistenceProvider();
    private final EclipseLinkJpaDialect jpaDialect = new EclipseLinkJpaDialect();

    @Override
    public jakarta.persistence.spi.PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public Map<String, Object> getJpaPropertyMap() {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("eclipselink.target-database", this.getDatabasePlatform());
        } else {
            String targetDatabase = this.determineTargetDatabaseName(this.getDatabase());
            if (targetDatabase != null) {
                jpaProperties.put("eclipselink.target-database", targetDatabase);
            }
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("eclipselink.ddl-generation", "create-tables");
            jpaProperties.put("eclipselink.ddl-generation.output-mode", "database");
        }
        if (this.isShowSql()) {
            jpaProperties.put("eclipselink.logging.level.sql", Level.FINE.toString());
            jpaProperties.put("eclipselink.logging.parameters", Boolean.TRUE.toString());
        }
        return jpaProperties;
    }

    @Nullable
    protected String determineTargetDatabaseName(Database database) {
        return switch (database) {
            case Database.DB2 -> "DB2";
            case Database.DERBY -> "Derby";
            case Database.HANA -> "HANA";
            case Database.HSQL -> "HSQL";
            case Database.INFORMIX -> "Informix";
            case Database.MYSQL -> "MySQL";
            case Database.ORACLE -> "Oracle";
            case Database.POSTGRESQL -> "PostgreSQL";
            case Database.SQL_SERVER -> "SQLServer";
            case Database.SYBASE -> "Sybase";
            default -> null;
        };
    }

    @Override
    public EclipseLinkJpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return JpaEntityManager.class;
    }
}

