/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.dao.DataAccessException;
import cn.taketoday.dao.support.DataAccessUtils;
import cn.taketoday.dao.support.PersistenceExceptionTranslator;
import cn.taketoday.jdbc.datasource.ConnectionHandle;
import cn.taketoday.jdbc.datasource.ConnectionHolder;
import cn.taketoday.jdbc.datasource.JdbcTransactionObjectSupport;
import cn.taketoday.jdbc.datasource.TransactionAwareDataSourceProxy;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.orm.jpa.DefaultJpaDialect;
import cn.taketoday.orm.jpa.EntityManagerFactoryInfo;
import cn.taketoday.orm.jpa.EntityManagerFactoryUtils;
import cn.taketoday.orm.jpa.EntityManagerHolder;
import cn.taketoday.orm.jpa.JpaDialect;
import cn.taketoday.transaction.CannotCreateTransactionException;
import cn.taketoday.transaction.IllegalTransactionStateException;
import cn.taketoday.transaction.NestedTransactionNotSupportedException;
import cn.taketoday.transaction.SavepointManager;
import cn.taketoday.transaction.TransactionDefinition;
import cn.taketoday.transaction.TransactionException;
import cn.taketoday.transaction.TransactionSystemException;
import cn.taketoday.transaction.support.AbstractPlatformTransactionManager;
import cn.taketoday.transaction.support.DefaultTransactionStatus;
import cn.taketoday.transaction.support.DelegatingTransactionDefinition;
import cn.taketoday.transaction.support.ResourceTransactionDefinition;
import cn.taketoday.transaction.support.ResourceTransactionManager;
import cn.taketoday.transaction.support.SynchronizationInfo;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import cn.taketoday.util.CollectionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class JpaTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
BeanFactoryAware,
InitializingBean {
    @Nullable
    private EntityManagerFactory entityManagerFactory;
    @Nullable
    private String persistenceUnitName;
    private final HashMap<String, Object> jpaPropertyMap = new HashMap();
    @Nullable
    private DataSource dataSource;
    private JpaDialect jpaDialect = new DefaultJpaDialect();
    @Nullable
    private Consumer<EntityManager> entityManagerInitializer;

    public JpaTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public JpaTransactionManager(EntityManagerFactory emf) {
        this();
        this.entityManagerFactory = emf;
        this.afterPropertiesSet();
    }

    public void setEntityManagerFactory(@Nullable EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    @Nullable
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    protected final EntityManagerFactory obtainEntityManagerFactory() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state((emf != null ? 1 : 0) != 0, (String)"No EntityManagerFactory set");
        return emf;
    }

    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    @Nullable
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaProperties(@Nullable Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(@Nullable Map<String, ?> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setDataSource(@Nullable DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            TransactionAwareDataSourceProxy proxy = (TransactionAwareDataSourceProxy)dataSource;
            this.dataSource = proxy.getTargetDataSource();
        } else {
            this.dataSource = dataSource;
        }
    }

    @Nullable
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setJpaDialect(@Nullable JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect != null ? jpaDialect : new DefaultJpaDialect();
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public void setEntityManagerInitializer(Consumer<EntityManager> entityManagerInitializer) {
        this.entityManagerInitializer = entityManagerInitializer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getEntityManagerFactory() == null) {
            this.setEntityManagerFactory(EntityManagerFactoryUtils.findEntityManagerFactory(beanFactory, this.getPersistenceUnitName()));
        }
    }

    public void afterPropertiesSet() {
        if (this.getEntityManagerFactory() == null) {
            throw new IllegalArgumentException("'entityManagerFactory' or 'persistenceUnitName' is required");
        }
        EntityManagerFactory entityManagerFactory = this.getEntityManagerFactory();
        if (entityManagerFactory instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)entityManagerFactory;
            DataSource dataSource = emfInfo.getDataSource();
            if (dataSource != null) {
                this.setDataSource(dataSource);
            }
            if ((jpaDialect = emfInfo.getJpaDialect()) != null) {
                this.setJpaDialect(jpaDialect);
            }
        }
    }

    public Object getResourceFactory() {
        return this.obtainEntityManagerFactory();
    }

    protected Object doGetTransaction() {
        JpaTransactionObject txObject = new JpaTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        EntityManagerHolder emHolder = (EntityManagerHolder)((Object)info.getResource((Object)this.obtainEntityManagerFactory()));
        if (emHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found thread-bound EntityManager [{}] for JPA transaction", (Object)emHolder.getEntityManager());
            }
            txObject.setEntityManagerHolder(emHolder, false);
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)info.getResource((Object)this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((JpaTransactionObject)((Object)transaction)).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)transaction);
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! JpaTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single JpaTransactionManager for all transactions on a single DataSource, no matter whether JPA or JDBC access.");
        }
        try {
            if (!txObject.hasEntityManagerHolder() || txObject.getEntityManagerHolder().isSynchronizedWithTransaction()) {
                EntityManager newEm = this.createEntityManagerForTransaction();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Opened new EntityManager [{}] for JPA transaction", (Object)newEm);
                }
                txObject.setEntityManagerHolder(new EntityManagerHolder(newEm), true);
            }
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            int timeoutToUse = this.determineTimeout(definition);
            Object transactionData = this.getJpaDialect().beginTransaction(em, (TransactionDefinition)new JpaTransactionDefinition(definition, timeoutToUse, txObject.isNewEntityManagerHolder()));
            txObject.setTransactionData(transactionData);
            txObject.setReadOnly(definition.isReadOnly());
            if (timeoutToUse != -1) {
                txObject.getEntityManagerHolder().setTimeoutInSeconds(timeoutToUse);
            }
            if (this.getDataSource() != null) {
                ConnectionHandle conHandle = this.getJpaDialect().getJdbcConnection(em, definition.isReadOnly());
                if (conHandle != null) {
                    ConnectionHolder conHolder = new ConnectionHolder(conHandle);
                    if (timeoutToUse != -1) {
                        conHolder.setTimeoutInSeconds(timeoutToUse);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exposing JPA transaction as JDBC [{}]", (Object)conHandle);
                    }
                    TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)conHolder);
                    txObject.setConnectionHolder(conHolder);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not exposing JPA transaction [{}] as JDBC transaction because JpaDialect [{}] does not support JDBC Connection retrieval", (Object)em, (Object)this.getJpaDialect());
                }
            }
            if (txObject.isNewEntityManagerHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.obtainEntityManagerFactory(), (Object)((Object)txObject.getEntityManagerHolder()));
            }
            txObject.getEntityManagerHolder().setSynchronizedWithTransaction(true);
        }
        catch (TransactionException ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw ex;
        }
        catch (Throwable ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not open JPA EntityManager for transaction", ex);
        }
    }

    protected EntityManager createEntityManagerForTransaction() {
        EntityManager em;
        EntityManagerFactory emf = this.obtainEntityManagerFactory();
        Map<String, Object> properties = this.getJpaPropertyMap();
        if (emf instanceof EntityManagerFactoryInfo) {
            em = ((EntityManagerFactoryInfo)emf).createNativeEntityManager(properties);
        } else {
            EntityManager entityManager = em = CollectionUtils.isNotEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        }
        if (this.entityManagerInitializer != null) {
            this.entityManagerInitializer.accept(em);
        }
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeEntityManagerAfterFailedBegin(JpaTransactionObject txObject) {
        if (txObject.isNewEntityManagerHolder()) {
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            try {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
            }
            catch (Throwable ex) {
                this.logger.debug("Could not rollback EntityManager after failed transaction begin", ex);
            }
            finally {
                EntityManagerFactoryUtils.closeEntityManager(em);
            }
            txObject.setEntityManagerHolder(null, false);
        }
    }

    protected Object doSuspend(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)transaction);
        txObject.setEntityManagerHolder(null, false);
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)((Object)info.unbindResource((Object)this.obtainEntityManagerFactory()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null && info.hasResource((Object)this.getDataSource())) {
            connectionHolder = (ConnectionHolder)info.unbindResource((Object)this.getDataSource());
        }
        return new SuspendedResourcesHolder(entityManagerHolder, connectionHolder);
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        info.bindResource((Object)this.obtainEntityManagerFactory(), (Object)resourcesHolder.getEntityManagerHolder());
        if (this.getDataSource() != null && resourcesHolder.getConnectionHolder() != null) {
            info.bindResource((Object)this.getDataSource(), (Object)resourcesHolder.getConnectionHolder());
        }
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug("Committing JPA transaction on EntityManager [{}]", (Object)txObject.getEntityManagerHolder().getEntityManager());
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            tx.commit();
        }
        catch (RollbackException ex) {
            DataAccessException dae;
            if (ex.getCause() instanceof RuntimeException && (dae = this.getJpaDialect().translateExceptionIfPossible((RuntimeException)ex.getCause())) != null) {
                throw dae;
            }
            throw new TransactionSystemException("Could not commit JPA transaction", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary((RuntimeException)ex, (PersistenceExceptionTranslator)this.getJpaDialect());
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug("Rolling back JPA transaction on EntityManager [{}]", (Object)txObject.getEntityManagerHolder().getEntityManager());
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        catch (PersistenceException ex) {
            throw new TransactionSystemException("Could not roll back JPA transaction", (Throwable)ex);
        }
        finally {
            if (!txObject.isNewEntityManagerHolder()) {
                txObject.getEntityManagerHolder().getEntityManager().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug("Setting JPA transaction on EntityManager [{}] rollback-only", (Object)txObject.getEntityManagerHolder().getEntityManager());
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)((Object)transaction);
        SynchronizationInfo info = TransactionSynchronizationManager.getSynchronizationInfo();
        if (txObject.isNewEntityManagerHolder()) {
            info.unbindResourceIfPossible((Object)this.obtainEntityManagerFactory());
        }
        txObject.getEntityManagerHolder().clear();
        if (this.getDataSource() != null && txObject.hasConnectionHolder()) {
            info.unbindResource((Object)this.getDataSource());
            ConnectionHandle conHandle = txObject.getConnectionHolder().getConnectionHandle();
            if (conHandle != null) {
                try {
                    this.getJpaDialect().releaseJdbcConnection(conHandle, txObject.getEntityManagerHolder().getEntityManager());
                }
                catch (Throwable ex) {
                    this.logger.error("Failed to release JDBC connection after transaction", ex);
                }
            }
        }
        this.getJpaDialect().cleanupTransaction(txObject.getTransactionData());
        if (txObject.isNewEntityManagerHolder()) {
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing JPA EntityManager [{}] after transaction", (Object)em);
            }
            EntityManagerFactoryUtils.closeEntityManager(em);
        } else {
            this.logger.debug("Not closing pre-bound JPA EntityManager after transaction");
        }
    }

    private class JpaTransactionObject
    extends JdbcTransactionObjectSupport {
        @Nullable
        private EntityManagerHolder entityManagerHolder;
        private boolean newEntityManagerHolder;
        @Nullable
        private Object transactionData;

        private JpaTransactionObject() {
        }

        public void setEntityManagerHolder(@Nullable EntityManagerHolder entityManagerHolder, boolean newEntityManagerHolder) {
            this.entityManagerHolder = entityManagerHolder;
            this.newEntityManagerHolder = newEntityManagerHolder;
        }

        public EntityManagerHolder getEntityManagerHolder() {
            Assert.state((this.entityManagerHolder != null ? 1 : 0) != 0, (String)"No EntityManagerHolder available");
            return this.entityManagerHolder;
        }

        public boolean hasEntityManagerHolder() {
            return this.entityManagerHolder != null;
        }

        public boolean isNewEntityManagerHolder() {
            return this.newEntityManagerHolder;
        }

        public boolean hasTransaction() {
            return this.entityManagerHolder != null && this.entityManagerHolder.isTransactionActive();
        }

        public void setTransactionData(@Nullable Object transactionData) {
            this.transactionData = transactionData;
            this.getEntityManagerHolder().setTransactionActive(true);
            if (transactionData instanceof SavepointManager) {
                this.getEntityManagerHolder().setSavepointManager((SavepointManager)transactionData);
            }
        }

        @Nullable
        public Object getTransactionData() {
            return this.transactionData;
        }

        public void setRollbackOnly() {
            EntityTransaction tx = this.getEntityManagerHolder().getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.setRollbackOnly();
            }
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            EntityTransaction tx = this.getEntityManagerHolder().getEntityManager().getTransaction();
            return tx.getRollbackOnly();
        }

        public void flush() {
            try {
                this.getEntityManagerHolder().getEntityManager().flush();
            }
            catch (RuntimeException ex) {
                throw DataAccessUtils.translateIfNecessary((RuntimeException)ex, (PersistenceExceptionTranslator)JpaTransactionManager.this.getJpaDialect());
            }
        }

        public Object createSavepoint() throws TransactionException {
            if (this.getEntityManagerHolder().isRollbackOnly()) {
                throw new CannotCreateTransactionException("Cannot create savepoint for transaction which is already marked as rollback-only");
            }
            return this.getSavepointManager().createSavepoint();
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.getSavepointManager().rollbackToSavepoint(savepoint);
            this.getEntityManagerHolder().resetRollbackOnly();
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this.getSavepointManager().releaseSavepoint(savepoint);
        }

        private SavepointManager getSavepointManager() {
            if (!this.isSavepointAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions");
            }
            SavepointManager savepointManager = this.getEntityManagerHolder().getSavepointManager();
            if (savepointManager == null) {
                throw new NestedTransactionNotSupportedException("JpaDialect does not support savepoints - check your JPA provider's capabilities");
            }
            return savepointManager;
        }
    }

    private static class JpaTransactionDefinition
    extends DelegatingTransactionDefinition
    implements ResourceTransactionDefinition {
        private final int timeout;
        private final boolean localResource;

        public JpaTransactionDefinition(TransactionDefinition targetDefinition, int timeout, boolean localResource) {
            super(targetDefinition);
            this.timeout = timeout;
            this.localResource = localResource;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public boolean isLocalResource() {
            return this.localResource;
        }
    }

    private static final class SuspendedResourcesHolder {
        private final EntityManagerHolder entityManagerHolder;
        @Nullable
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(EntityManagerHolder emHolder, @Nullable ConnectionHolder conHolder) {
            this.entityManagerHolder = emHolder;
            this.connectionHolder = conHolder;
        }

        private EntityManagerHolder getEntityManagerHolder() {
            return this.entityManagerHolder;
        }

        @Nullable
        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

