/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.jpa;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.orm.jpa.EntityManagerFactoryUtils;
import cn.taketoday.util.CollectionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class EntityManagerFactoryAccessor
implements BeanFactoryAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private EntityManagerFactory entityManagerFactory;
    @Nullable
    private String persistenceUnitName;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();

    public void setEntityManagerFactory(@Nullable EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    @Nullable
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    protected final EntityManagerFactory obtainEntityManagerFactory() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state((emf != null ? 1 : 0) != 0, (String)"No EntityManagerFactory set");
        return emf;
    }

    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    @Nullable
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(@Nullable Map<String, Object> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getEntityManagerFactory() == null) {
            this.setEntityManagerFactory(EntityManagerFactoryUtils.findEntityManagerFactory(beanFactory, this.getPersistenceUnitName()));
        }
    }

    protected EntityManager createEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.obtainEntityManagerFactory();
        Map<String, Object> properties = this.getJpaPropertyMap();
        return CollectionUtils.isNotEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
    }

    @Nullable
    protected EntityManager getTransactionalEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.obtainEntityManagerFactory();
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, this.getJpaPropertyMap());
    }
}

