/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.orm.hibernate5;

import cn.taketoday.core.Ordered;
import cn.taketoday.dao.DataAccessException;
import cn.taketoday.orm.hibernate5.SessionFactoryUtils;
import cn.taketoday.orm.hibernate5.SessionHolder;
import cn.taketoday.transaction.support.TransactionSynchronization;
import cn.taketoday.transaction.support.TransactionSynchronizationManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;

public class HibernateSessionSynchronization
implements TransactionSynchronization,
Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final boolean newSession;
    private boolean holderActive = true;

    public HibernateSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory) {
        this(sessionHolder, sessionFactory, false);
    }

    public HibernateSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.newSession = newSession;
    }

    private Session getCurrentSession() {
        return this.sessionHolder.getSession();
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            Session session = this.getCurrentSession();
            if (session instanceof SessionImplementor) {
                SessionImplementor sessionImpl = (SessionImplementor)session;
                sessionImpl.getJdbcCoordinator().getLogicalConnection().manualDisconnect();
            }
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void flush() {
        SessionFactoryUtils.flush(this.getCurrentSession(), false);
    }

    public void beforeCommit(boolean readOnly) throws DataAccessException {
        Session session;
        if (!readOnly && !FlushMode.MANUAL.equals((Object)(session = this.getCurrentSession()).getHibernateFlushMode())) {
            SessionFactoryUtils.flush(this.getCurrentSession(), true);
        }
    }

    public void beforeCompletion() {
        try {
            Session session = this.sessionHolder.getSession();
            if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setHibernateFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            if (session instanceof SessionImplementor) {
                SessionImplementor sessionImpl = (SessionImplementor)session;
                sessionImpl.getJdbcCoordinator().getLogicalConnection().manualDisconnect();
            }
        }
        finally {
            if (this.newSession) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                this.holderActive = false;
            }
        }
    }

    public void afterCommit() {
    }

    public void afterCompletion(int status) {
        try {
            if (status != 0) {
                this.sessionHolder.getSession().clear();
            }
        }
        finally {
            this.sessionHolder.setSynchronizedWithTransaction(false);
            if (this.newSession) {
                SessionFactoryUtils.closeSession(this.sessionHolder.getSession());
            }
        }
    }
}

