/*
 * Original Author -> Harry Yang (taketoday@foxmail.com) https://taketoday.cn
 * Copyright © TODAY & 2017 - 2022 All Rights Reserved.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see [http://www.gnu.org/licenses/]
 */

package cn.taketoday.core.conversion.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.ConverterFactory;
import cn.taketoday.util.ClassUtils;

/**
 * Converts from a Integer to a {@link Enum} by calling {@link Class#getEnumConstants()}.
 *
 * @author Yanming Zhou
 * @author Stephane Nicoll
 * @since 4.0
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
final class IntegerToEnumConverterFactory implements ConverterFactory<Integer, Enum> {

  @Override
  public <T extends Enum> Converter<Integer, T> getConverter(Class<T> targetType) {
    return new IntegerToEnum(ClassUtils.getEnumType(targetType));
  }

  private record IntegerToEnum<T extends Enum>(Class<T> enumType) implements Converter<Integer, T> {

    @Override
    public T convert(Integer source) {
      return this.enumType.getEnumConstants()[source];
    }
  }

}
