/*
 * Original Author -> Harry Yang (taketoday@foxmail.com) https://taketoday.cn
 * Copyright © TODAY & 2017 - 2022 All Rights Reserved.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see [http://www.gnu.org/licenses/]
 */

package cn.taketoday.expression.spel;

import cn.taketoday.expression.EvaluationContext;
import cn.taketoday.expression.EvaluationException;
import cn.taketoday.lang.Nullable;

/**
 * Base superclass for compiled expressions. Each generated compiled expression class
 * will extend this class and implement the {@link #getValue} method. It is not intended
 * to be subclassed by user code.
 *
 * @author Andy Clement
 * @since 4.0
 */
public abstract class CompiledExpression {

  /**
   * Subclasses of CompiledExpression generated by SpelCompiler will provide an
   * implementation of this method.
   */
  public abstract Object getValue(@Nullable Object target, @Nullable EvaluationContext context)
          throws EvaluationException;

}
