/*
 * Copyright 2017 - 2024 the original author or authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see [https://www.gnu.org/licenses/]
 */

package infra.validation.method;

import java.lang.reflect.Method;
import java.util.List;

import infra.context.MessageSourceResolvable;
import infra.lang.Assert;

/**
 * Exception that is a {@link MethodValidationResult}.
 *
 * @author Rossen Stoyanchev
 * @author <a href="https://github.com/TAKETODAY">海子 Yang</a>
 * @see MethodValidator
 * @since 4.0
 */
public class MethodValidationException extends RuntimeException implements MethodValidationResult {

  private final MethodValidationResult validationResult;

  public MethodValidationException(MethodValidationResult validationResult) {
    super(validationResult.toString());
    Assert.notNull(validationResult, "MethodValidationResult is required");
    this.validationResult = validationResult;
  }

  @Override
  public Object getTarget() {
    return this.validationResult.getTarget();
  }

  @Override
  public Method getMethod() {
    return this.validationResult.getMethod();
  }

  @Override
  public boolean isForReturnValue() {
    return this.validationResult.isForReturnValue();
  }

  @Override
  public List<ParameterValidationResult> getParameterValidationResults() {
    return this.validationResult.getParameterValidationResults();
  }

  @Override
  public List<MessageSourceResolvable> getCrossParameterValidationResults() {
    return this.validationResult.getCrossParameterValidationResults();
  }

}
