/*
 * Copyright 2017 - 2024 the original author or authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see [https://www.gnu.org/licenses/]
 */

package infra.jmx.access;

import infra.jmx.JmxException;

/**
 * Thrown when an invocation on an MBean resource failed with an exception (either
 * a reflection exception or an exception thrown by the target method itself).
 *
 * @author Juergen Hoeller
 * @author <a href="https://github.com/TAKETODAY">Harry Yang</a>
 * @see MBeanClientInterceptor
 * @since 4.0
 */
public class InvocationFailureException extends JmxException {

  /**
   * Create a new {@code InvocationFailureException} with the supplied
   * error message.
   *
   * @param msg the detail message
   */
  public InvocationFailureException(String msg) {
    super(msg);
  }

  /**
   * Create a new {@code InvocationFailureException} with the
   * specified error message and root cause.
   *
   * @param msg the detail message
   * @param cause the root cause
   */
  public InvocationFailureException(String msg, Throwable cause) {
    super(msg, cause);
  }

}
