/*
 * Copyright 2017 - 2025 the original author or authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see [https://www.gnu.org/licenses/]
 */

package infra.context.properties.bind;

import org.jspecify.annotations.Nullable;

import infra.core.env.PropertyResolver;

/**
 * Optional strategy that used by a {@link Binder} to resolve property placeholders.
 *
 * @author Phillip Webb
 * @author Madhura Bhave
 * @author <a href="https://github.com/TAKETODAY">Harry Yang</a>
 * @see PropertySourcesPlaceholdersResolver
 * @since 4.0
 */
@FunctionalInterface
public interface PlaceholdersResolver {

  /**
   * No-op {@link PropertyResolver}.
   */
  PlaceholdersResolver NONE = value -> value;

  /**
   * Called to resolve any placeholders in the given value.
   *
   * @param value the source value
   * @return a value with placeholders resolved
   */
  @Nullable
  Object resolvePlaceholders(@Nullable Object value);

}
