/*
 * Copyright 2017 - 2025 the original author or authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see [https://www.gnu.org/licenses/]
 */

package infra.context.properties.bind;

import org.jspecify.annotations.Nullable;

import java.util.function.Consumer;

import infra.context.properties.source.ConfigurationProperty;
import infra.context.properties.source.ConfigurationPropertyName;
import infra.lang.Assert;

/**
 * {@link BindHandler} that can be used to track bound configuration properties.
 *
 * @author Madhura Bhave
 * @author <a href="https://github.com/TAKETODAY">Harry Yang</a>
 * @since 4.0
 */
public class BoundPropertiesTrackingBindHandler extends AbstractBindHandler {

  private final Consumer<ConfigurationProperty> consumer;

  public BoundPropertiesTrackingBindHandler(Consumer<ConfigurationProperty> consumer) {
    Assert.notNull(consumer, "Consumer is required");
    this.consumer = consumer;
  }

  @Nullable
  @Override
  public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
    if (context.getConfigurationProperty() != null && name.equals(context.getConfigurationProperty().getName())) {
      this.consumer.accept(context.getConfigurationProperty());
    }
    return super.onSuccess(name, target, context, result);
  }

}
