/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation.beanvalidation;

import cn.taketoday.lang.Assert;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.metadata.BeanDescriptor;
import java.util.Set;
import java.util.function.Supplier;

public class SuppliedValidator
implements Validator {
    private final Supplier<Validator> validatorSupplier;

    public SuppliedValidator(Supplier<Validator> validatorSupplier) {
        Assert.notNull(validatorSupplier, (String)"validatorSupplier is required");
        this.validatorSupplier = validatorSupplier;
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.getValidator().validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.getValidator().validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.getValidator().validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.getValidator().getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        return (T)this.getValidator().unwrap(type);
    }

    public ExecutableValidator forExecutables() {
        return this.getValidator().forExecutables();
    }

    public Validator getValidator() {
        return this.validatorSupplier.get();
    }
}

