/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation.beanvalidation;

import cn.taketoday.aop.ProxyMethodInvocation;
import cn.taketoday.aop.framework.AopProxyUtils;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.beans.factory.FactoryBean;
import cn.taketoday.beans.factory.SmartFactoryBean;
import cn.taketoday.core.BridgeMethodResolver;
import cn.taketoday.core.OrderedSupport;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.validation.annotation.Validated;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MethodValidationInterceptor
extends OrderedSupport
implements MethodInterceptor {
    private final Validator validator;

    public MethodValidationInterceptor() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(validatorFactory.getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = validator;
        this.setOrder(Integer.MIN_VALUE);
    }

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Set result;
        if (this.isFactoryBeanMetadataMethod(invocation.getMethod())) {
            return invocation.proceed();
        }
        Class[] groups = this.determineValidationGroups(invocation);
        ExecutableValidator execVal = this.validator.forExecutables();
        Method methodToValidate = invocation.getMethod();
        Object target = invocation.getThis();
        if (target == null && invocation instanceof ProxyMethodInvocation) {
            ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)invocation;
            target = methodInvocation.getProxy();
        }
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        try {
            result = execVal.validateParameters(target, methodToValidate, invocation.getArguments(), groups);
        }
        catch (IllegalArgumentException ex) {
            methodToValidate = BridgeMethodResolver.findBridgedMethod((Method)ReflectionUtils.getMostSpecificMethod((Method)invocation.getMethod(), target.getClass()));
            result = execVal.validateParameters(target, methodToValidate, invocation.getArguments(), groups);
        }
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        Object returnValue = invocation.proceed();
        result = execVal.validateReturnValue(target, methodToValidate, returnValue, groups);
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        return returnValue;
    }

    private boolean isFactoryBeanMetadataMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isInterface()) {
            return (clazz == FactoryBean.class || clazz == SmartFactoryBean.class) && !method.getName().equals("getObject");
        }
        Class<SmartFactoryBean> factoryBeanType = null;
        if (SmartFactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = SmartFactoryBean.class;
        } else if (FactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = FactoryBean.class;
        }
        return factoryBeanType != null && !method.getName().equals("getObject") && ReflectionUtils.hasMethod(factoryBeanType, (Method)method);
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Validated validatedAnn = (Validated)AnnotationUtils.findAnnotation((Method)invocation.getMethod(), Validated.class);
        if (validatedAnn == null) {
            ProxyMethodInvocation methodInvocation;
            Object proxy;
            Object target = invocation.getThis();
            if (target != null) {
                validatedAnn = (Validated)AnnotationUtils.findAnnotation(target.getClass(), Validated.class);
            } else if (invocation instanceof ProxyMethodInvocation && AopUtils.isAopProxy((Object)(proxy = (methodInvocation = (ProxyMethodInvocation)invocation).getProxy()))) {
                Class type;
                Class[] classArray = AopProxyUtils.proxiedUserInterfaces((Object)proxy);
                int n = classArray.length;
                for (int i = 0; i < n && (validatedAnn = (Validated)AnnotationUtils.findAnnotation((Class)(type = classArray[i]), Validated.class)) == null; ++i) {
                }
            }
        }
        return validatedAnn != null ? validatedAnn.value() : Constant.EMPTY_CLASSES;
    }
}

