/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation.beanvalidation;

import cn.taketoday.beans.factory.DisposableBean;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ApplicationContextAware;
import cn.taketoday.context.MessageSource;
import cn.taketoday.core.DefaultParameterNameDiscoverer;
import cn.taketoday.core.ParameterNameDiscoverer;
import cn.taketoday.core.io.Resource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.validation.beanvalidation.ContextConstraintValidatorFactory;
import cn.taketoday.validation.beanvalidation.InfraValidatorAdapter;
import cn.taketoday.validation.beanvalidation.LocaleContextMessageInterpolator;
import cn.taketoday.validation.beanvalidation.MessageSourceResourceBundleLocator;
import jakarta.validation.ClockProvider;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class LocalValidatorFactoryBean
extends InfraValidatorAdapter
implements ValidatorFactory,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    @Nullable
    private Class providerClass;
    @Nullable
    private ValidationProviderResolver validationProviderResolver;
    @Nullable
    private MessageInterpolator messageInterpolator;
    @Nullable
    private TraversableResolver traversableResolver;
    @Nullable
    private ConstraintValidatorFactory constraintValidatorFactory;
    @Nullable
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    @Nullable
    private Resource[] mappingLocations;
    private final Map<String, String> validationPropertyMap = new HashMap<String, String>();
    @Nullable
    private Consumer<Configuration<?>> configurationInitializer;
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private ValidatorFactory validatorFactory;

    public void setProviderClass(Class providerClass) {
        this.providerClass = providerClass;
    }

    public void setValidationProviderResolver(ValidationProviderResolver validationProviderResolver) {
        this.validationProviderResolver = validationProviderResolver;
    }

    public void setMessageInterpolator(@Nullable MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public void setValidationMessageSource(MessageSource messageSource) {
        this.messageInterpolator = HibernateValidatorDelegate.buildMessageInterpolator(messageSource);
    }

    public void setTraversableResolver(@Nullable TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public void setConstraintValidatorFactory(@Nullable ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public void setParameterNameDiscoverer(@Nullable ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setMappingLocations(Resource ... mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void setValidationProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)jpaProperties, this.validationPropertyMap);
    }

    public void setValidationPropertyMap(@Nullable Map<String, String> validationProperties) {
        if (validationProperties != null) {
            this.validationPropertyMap.putAll(validationProperties);
        }
    }

    public Map<String, String> getValidationPropertyMap() {
        return this.validationPropertyMap;
    }

    public void setConfigurationInitializer(Consumer<Configuration<?>> configurationInitializer) {
        this.configurationInitializer = configurationInitializer;
    }

    @Override
    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        ConstraintValidatorFactory targetConstraintValidatorFactory;
        MessageInterpolator targetInterpolator;
        Configuration configuration;
        if (this.providerClass != null) {
            bootstrap = Validation.byProvider((Class)this.providerClass);
            if (this.validationProviderResolver != null) {
                bootstrap = bootstrap.providerResolver(this.validationProviderResolver);
            }
            configuration = bootstrap.configure();
        } else {
            bootstrap = Validation.byDefaultProvider();
            if (this.validationProviderResolver != null) {
                bootstrap = bootstrap.providerResolver(this.validationProviderResolver);
            }
            configuration = bootstrap.configure();
        }
        if (this.applicationContext != null) {
            try {
                Method eclMethod = configuration.getClass().getMethod("externalClassLoader", ClassLoader.class);
                ReflectionUtils.invokeMethod((Method)eclMethod, (Object)configuration, (Object[])new Object[]{this.applicationContext.getClassLoader()});
            }
            catch (NoSuchMethodException eclMethod) {
                // empty catch block
            }
        }
        if ((targetInterpolator = this.messageInterpolator) == null) {
            targetInterpolator = configuration.getDefaultMessageInterpolator();
        }
        configuration.messageInterpolator((MessageInterpolator)new LocaleContextMessageInterpolator(targetInterpolator));
        if (this.traversableResolver != null) {
            configuration.traversableResolver(this.traversableResolver);
        }
        if ((targetConstraintValidatorFactory = this.constraintValidatorFactory) == null && this.applicationContext != null) {
            targetConstraintValidatorFactory = new ContextConstraintValidatorFactory(this.applicationContext.getAutowireCapableBeanFactory());
        }
        if (targetConstraintValidatorFactory != null) {
            configuration.constraintValidatorFactory(targetConstraintValidatorFactory);
        }
        if (this.parameterNameDiscoverer != null) {
            this.configureParameterNameProvider(this.parameterNameDiscoverer, configuration);
        }
        ArrayList<InputStream> mappingStreams = null;
        if (this.mappingLocations != null) {
            mappingStreams = new ArrayList<InputStream>(this.mappingLocations.length);
            for (Resource location : this.mappingLocations) {
                try {
                    InputStream stream = location.getInputStream();
                    mappingStreams.add(stream);
                    configuration.addMapping(stream);
                }
                catch (IOException ex) {
                    this.closeMappingStreams(mappingStreams);
                    throw new IllegalStateException("Cannot read mapping resource: " + location);
                }
            }
        }
        this.validationPropertyMap.forEach((arg_0, arg_1) -> ((Configuration)configuration).addProperty(arg_0, arg_1));
        if (this.configurationInitializer != null) {
            this.configurationInitializer.accept(configuration);
        }
        this.postProcessConfiguration(configuration);
        try {
            this.validatorFactory = configuration.buildValidatorFactory();
            this.setTargetValidator(this.validatorFactory.getValidator());
        }
        finally {
            this.closeMappingStreams(mappingStreams);
        }
    }

    private void configureParameterNameProvider(final ParameterNameDiscoverer discoverer, Configuration<?> configuration) {
        final ParameterNameProvider defaultProvider = configuration.getDefaultParameterNameProvider();
        configuration.parameterNameProvider(new ParameterNameProvider(){

            public List<String> getParameterNames(Constructor<?> constructor) {
                String[] paramNames = discoverer.getParameterNames(constructor);
                return paramNames != null ? Arrays.asList(paramNames) : defaultProvider.getParameterNames(constructor);
            }

            public List<String> getParameterNames(Method method) {
                String[] paramNames = discoverer.getParameterNames((Executable)method);
                return paramNames != null ? Arrays.asList(paramNames) : defaultProvider.getParameterNames(method);
            }
        });
    }

    private void closeMappingStreams(@Nullable List<InputStream> mappingStreams) {
        if (CollectionUtils.isNotEmpty(mappingStreams)) {
            for (InputStream stream : mappingStreams) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void postProcessConfiguration(Configuration<?> configuration) {
    }

    public Validator getValidator() {
        return this.validatorFactory().getValidator();
    }

    public ValidatorContext usingContext() {
        return this.validatorFactory().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.validatorFactory().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.validatorFactory().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.validatorFactory().getConstraintValidatorFactory();
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.validatorFactory().getParameterNameProvider();
    }

    private ValidatorFactory validatorFactory() {
        Assert.state((this.validatorFactory != null ? 1 : 0) != 0, (String)"No target ValidatorFactory set");
        return this.validatorFactory;
    }

    public ClockProvider getClockProvider() {
        return this.validatorFactory().getClockProvider();
    }

    @Override
    public <T> T unwrap(@Nullable Class<T> type) {
        if (type == null || !ValidatorFactory.class.isAssignableFrom(type)) {
            try {
                return super.unwrap(type);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        if (this.validatorFactory != null) {
            try {
                return (T)this.validatorFactory.unwrap(type);
            }
            catch (ValidationException ex) {
                if (ValidatorFactory.class == type) {
                    return (T)this.validatorFactory;
                }
                throw ex;
            }
        }
        throw new ValidationException("Cannot unwrap to " + type);
    }

    public void close() {
        if (this.validatorFactory != null) {
            this.validatorFactory.close();
        }
    }

    public void destroy() {
        this.close();
    }

    private static class HibernateValidatorDelegate {
        private HibernateValidatorDelegate() {
        }

        public static MessageInterpolator buildMessageInterpolator(MessageSource messageSource) {
            return new ResourceBundleMessageInterpolator((ResourceBundleLocator)new MessageSourceResourceBundleLocator(messageSource));
        }
    }
}

