/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation.beanvalidation;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.support.ComposablePointcut;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.validation.beanvalidation.MethodValidationExcludeFilter;
import cn.taketoday.validation.beanvalidation.MethodValidationPostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FilteredMethodValidationPostProcessor
extends MethodValidationPostProcessor {
    private final Collection<MethodValidationExcludeFilter> excludeFilters;

    public FilteredMethodValidationPostProcessor(Stream<? extends MethodValidationExcludeFilter> excludeFilters) {
        this.excludeFilters = excludeFilters.collect(Collectors.toList());
    }

    public FilteredMethodValidationPostProcessor(Collection<? extends MethodValidationExcludeFilter> excludeFilters) {
        this.excludeFilters = new ArrayList<MethodValidationExcludeFilter>(excludeFilters);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Advisor advisor = this.advisor;
        if (advisor instanceof DefaultPointcutAdvisor) {
            DefaultPointcutAdvisor advisor2 = (DefaultPointcutAdvisor)advisor;
            advisor2.setPointcut((Pointcut)new ComposablePointcut(advisor2.getPointcut()).intersection(this::isIncluded));
        }
    }

    private boolean isIncluded(Class<?> candidate) {
        for (MethodValidationExcludeFilter exclusionFilter : this.excludeFilters) {
            if (!exclusionFilter.isExcluded(candidate)) continue;
            return false;
        }
        return true;
    }
}

