/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.validation.beanvalidation;

import cn.taketoday.aop.framework.AopProxyUtils;
import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanInitializationException;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Iterator;
import java.util.Set;

public class BeanValidationPostProcessor
implements InitializationBeanPostProcessor,
InitializingBean {
    @Nullable
    private Validator validator;
    private boolean afterInitialization = false;

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    public void setAfterInitialization(boolean afterInitialization) {
        this.afterInitialization = afterInitialization;
    }

    public void afterPropertiesSet() {
        if (this.validator == null) {
            this.validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!this.afterInitialization) {
            this.doValidate(bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.afterInitialization) {
            this.doValidate(bean);
        }
        return bean;
    }

    protected void doValidate(Object bean) {
        Set result;
        Assert.state((this.validator != null ? 1 : 0) != 0, (String)"No Validator set");
        Object objectToValidate = AopProxyUtils.getSingletonTarget((Object)bean);
        if (objectToValidate == null) {
            objectToValidate = bean;
        }
        if (!(result = this.validator.validate(objectToValidate, new Class[0])).isEmpty()) {
            StringBuilder sb = new StringBuilder("Bean state is invalid: ");
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)it.next();
                sb.append(violation.getPropertyPath()).append(" - ").append(violation.getMessage());
                if (!it.hasNext()) continue;
                sb.append("; ");
            }
            throw new BeanInitializationException(sb.toString());
        }
    }
}

